/*
 * Decompiled with CFR 0.152.
 */
package LinuxCommandExecutor;

import enTity.interface_usage;
import iptv_api.BandwidthUsage;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;

public class LinuxCommandExecutor {
    public List<Double> usageSystem(List<String> content) {
        ArrayList<Double> usage = new ArrayList<Double>();
        try {
            for (String obj : content) {
                String line;
                System.out.println("Obj:" + obj);
                ProcessBuilder processBuilder = new ProcessBuilder(new String[0]);
                processBuilder.command("bash", "-c", obj);
                Process process = processBuilder.start();
                BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
                while ((line = reader.readLine()) != null) {
                    line = line.trim();
                    line = line.substring(0, line.trim().length() - 1);
                    usage.add(Double.parseDouble(line));
                    System.out.println("Out:" + line);
                }
            }
        }
        catch (Exception e) {
            System.out.println("Exception e:" + e.getMessage());
        }
        return usage;
    }

    public List<Integer> usage(List<String> content) {
        ArrayList<Integer> usage = new ArrayList<Integer>();
        try {
            for (String obj : content) {
                String line;
                System.out.println("Obj:" + obj);
                ProcessBuilder processBuilder = new ProcessBuilder(new String[0]);
                processBuilder.command("bash", "-c", obj);
                Process process = processBuilder.start();
                BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
                while ((line = reader.readLine()) != null) {
                    line = line.trim();
                    usage.add(Integer.parseInt(line));
                    System.out.println("Out:" + line);
                }
            }
        }
        catch (Exception e) {
            System.out.println("Exception e:" + e.getMessage());
        }
        return usage;
    }

    public interface_usage Interface(String inter) {
        interface_usage obj = new interface_usage();
        try {
            String line;
            ProcessBuilder processBuilder = new ProcessBuilder(new String[0]);
            processBuilder.command("bash", "-c", "ifconfig " + inter + " | grep packets |awk '{print $5}' |tr '\\n' ' '");
            Process process = processBuilder.start();
            BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            while ((line = reader.readLine()) != null) {
                line = line.trim();
                System.out.println("Out:" + line);
                double[] no = new double[2];
                try {
                    String[] di = line.split(" ");
                    no[0] = Double.parseDouble(di[0]) / 1.073741824E9;
                    no[1] = Double.parseDouble(di[1]) / 1.073741824E9;
                    double avg = (no[0] + no[1]) / 2.0;
                    String avgparse = new DecimalFormat("#.##").format(avg);
                    String tx_parse = new DecimalFormat("#.##").format(no[1]);
                    String rx_parse = new DecimalFormat("#.##").format(no[0]);
                    obj.setAverage_rate(avgparse + " GB");
                    obj.setTransmit_rate(tx_parse + " GB");
                    obj.setReceive_rate(rx_parse + " GB");
                }
                catch (Exception e) {
                    System.out.println("Exception e1:" + e.getMessage());
                }
            }
        }
        catch (Exception e) {
            System.out.println("Exception e:" + e.getMessage());
        }
        return obj;
    }

    public List<BandwidthUsage> getInterfaceSpeed(List<String> net_interface) {
        String output = "";
        ArrayList<BandwidthUsage> content = new ArrayList<BandwidthUsage>();
        try {
            for (String in : net_interface) {
                String line;
                BandwidthUsage object = new BandwidthUsage();
                ProcessBuilder processBuilder = new ProcessBuilder(new String[0]);
                processBuilder.command("bash", "-c", "ethtool " + in + " | grep Speed");
                Process process = processBuilder.start();
                BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
                while ((line = reader.readLine()) != null) {
                    output = line;
                }
                output = output.replace("Speed", "");
                output = output.replace(":", "").trim();
                object.setSpeed(output);
                object.setInterface_name(in);
                interface_usage sub_obj = new LinuxCommandExecutor().Interface(in);
                object.setAvg_rate(sub_obj.getAverage_rate());
                object.setReceive_rate(sub_obj.getReceive_rate());
                object.setTransmit_rate(sub_obj.getTransmit_rate());
                content.add(object);
            }
        }
        catch (Exception e) {
            System.out.println("Exception at getInterfaceSpeed:" + e.getMessage());
        }
        return content;
    }

    public String removeUsrBinLocalFile(String file) {
        String result = "";
        try {
            System.out.println("file:" + file);
            String[] commands = new String[]{"sudo rm " + file};
            String output = "";
            for (String c : commands) {
                Process process = Runtime.getRuntime().exec(c, null, null);
                BufferedReader in = new BufferedReader(new InputStreamReader(process.getInputStream()));
                String line = null;
                while ((line = in.readLine()) != null) {
                    output = output + "\n" + line;
                }
            }
            result = result + output;
            System.out.println("Success:" + result);
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
        return result;
    }

    public String removeFile(String file) {
        String result = "";
        try {
            System.out.println("file:" + file);
            String[] commands = new String[]{"rm " + file};
            String output = "";
            for (String c : commands) {
                Process process = Runtime.getRuntime().exec(c, null, null);
                BufferedReader in = new BufferedReader(new InputStreamReader(process.getInputStream()));
                String line = null;
                while ((line = in.readLine()) != null) {
                    output = output + "\n" + line;
                }
            }
            result = result + output;
            System.out.println("Success:" + result);
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
        return result;
    }

    public String removeFolder(String folder) {
        String result = "";
        try {
            System.out.println("file:" + folder);
            String[] commands = new String[]{"rm -r " + folder};
            String output = "";
            for (String c : commands) {
                Process process = Runtime.getRuntime().exec(c, null, null);
                BufferedReader in = new BufferedReader(new InputStreamReader(process.getInputStream()));
                String line = null;
                while ((line = in.readLine()) != null) {
                    output = output + "\n" + line;
                }
            }
            result = result + output;
            System.out.println("Success:" + result);
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
        return result;
    }

    public boolean getTrackExtractor(String udp, int channel_id) {
        System.out.println("udp:" + udp);
        boolean status = false;
        try {
            String line;
            ProcessBuilder processBuilder = new ProcessBuilder(new String[0]);
            processBuilder.command("bash", "-c", "timeout 15s ffprobe -show_programs " + udp + " 2>&1 | grep -E 'Audio'");
            Process process = processBuilder.start();
            BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            while ((line = reader.readLine()) != null) {
                if ((line = line.trim()).contains("Stream #0")) {
                    try {
                        String[] txt = line.trim().split(":");
                        String language = txt[1].contains("](") ? txt[1].substring(txt[1].indexOf("(") + 1, txt[1].length() - 1) : "Default";
                        String stream_type = txt[2].trim();
                        String codec = txt[3].substring(0, txt[3].indexOf("(")).trim();
                        System.out.println("Language:" + language);
                        System.out.println("stream type:" + stream_type);
                        System.out.println("codec:" + codec);
                    }
                    catch (Exception e) {
                        System.out.println("Exception at track split:" + e.getMessage());
                    }
                }
                status = true;
            }
        }
        catch (Exception e) {
            System.out.println("Exception at trackextractor:" + e.getMessage());
            status = false;
        }
        return status;
    }

    public String giveWritePermission(String file) {
        String result = "";
        try {
            System.out.println("file:" + file);
            String[] commands = new String[]{"chmod 777 " + file};
            String output = "";
            for (String c : commands) {
                Process process = Runtime.getRuntime().exec(c, null, null);
                BufferedReader in = new BufferedReader(new InputStreamReader(process.getInputStream()));
                String line = null;
                while ((line = in.readLine()) != null) {
                    output = output + "\n" + line;
                }
            }
            result = result + output;
            System.out.println("Success:" + result);
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
        return result;
    }

    public String givePermission(String file) {
        String result = "";
        try {
            System.out.println("file:" + file);
            String[] commands = new String[]{"chmod +x " + file};
            String output = "";
            for (String c : commands) {
                Process process = Runtime.getRuntime().exec(c, null, null);
                BufferedReader in = new BufferedReader(new InputStreamReader(process.getInputStream()));
                String line = null;
                while ((line = in.readLine()) != null) {
                    output = output + "\n" + line;
                }
            }
            result = result + output;
            System.out.println("Success:" + result);
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
        return result;
    }

    public String moveServiceFile(int stream_id) {
        String result = "";
        try {
            String[] commands = new String[]{"sudo cp /home/user/stream" + stream_id + " /usr/local/bin"};
            String output = "";
            for (String c : commands) {
                Process process = Runtime.getRuntime().exec(c, null, null);
                BufferedReader in = new BufferedReader(new InputStreamReader(process.getInputStream()));
                String line = null;
                while ((line = in.readLine()) != null) {
                    output = output + "\n" + line;
                }
            }
            result = result + output;
            System.out.println("Success:" + result);
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
        return result;
    }

    public String copyActiveStream(String source, String destination) {
        String result = "";
        try {
            String[] commands = new String[]{"sudo cp " + source + " " + destination};
            String output = "";
            for (String c : commands) {
                Process process = Runtime.getRuntime().exec(c, null, null);
                BufferedReader in = new BufferedReader(new InputStreamReader(process.getInputStream()));
                String line = null;
                while ((line = in.readLine()) != null) {
                    output = output + "\n" + line;
                }
                Thread.sleep(2000L);
            }
            result = result + output;
            System.out.println("Success:" + result);
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
        return result;
    }

    public String copyDefaultServiceFile(int stream_id) {
        String result = "";
        try {
            String[] commands = new String[]{"sudo cp /usr/local/bin/default_service /usr/local/bin/stream" + stream_id};
            String output = "";
            for (String c : commands) {
                Process process = Runtime.getRuntime().exec(c, null, null);
                BufferedReader in = new BufferedReader(new InputStreamReader(process.getInputStream()));
                String line = null;
                while ((line = in.readLine()) != null) {
                    output = output + "\n" + line;
                }
                Thread.sleep(2000L);
            }
            result = result + output;
            System.out.println("Success:" + result);
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
        return result;
    }

    public String makeDirectory(String directory_name) {
        String result = "";
        try {
            String[] commands = new String[]{"mkdir  " + directory_name};
            String output = "";
            for (String c : commands) {
                Process process = Runtime.getRuntime().exec(c, null, null);
                BufferedReader in = new BufferedReader(new InputStreamReader(process.getInputStream()));
                String line = null;
                while ((line = in.readLine()) != null) {
                    output = output + "\n" + line;
                }
                Thread.sleep(2000L);
            }
            result = result + output;
            System.out.println("Success:" + directory_name);
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
        return result;
    }

    public boolean getfile(String file) {
        boolean status = false;
        String result = "";
        try {
            System.out.println("file:" + file);
            String[] commands = new String[]{"find " + file};
            String output = "";
            for (String c : commands) {
                Process process = Runtime.getRuntime().exec(c, null, null);
                BufferedReader in = new BufferedReader(new InputStreamReader(process.getInputStream()));
                String line = null;
                while ((line = in.readLine()) != null) {
                    output = output + "\n" + line;
                    status = true;
                }
            }
            result = result + output;
            System.out.println("Success:" + result);
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
        return status;
    }
}

