/*
 * Decompiled with CFR 0.152.
 */
package iptvlistener;

import LinuxCommandExecutor.LinuxCommandExecutor;
import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import com.sun.net.httpserver.HttpServer;
import enTity.channels;
import enTity.server_detail;
import iptvlistener.FfprobeStreamFiles;
import iptvlistener.VODListener;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Scanner;
import java.util.concurrent.Executors;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.json.simple.JSONObject;
import org.json.simple.JSONValue;
import org.json.simple.parser.JSONParser;

public class IPTVListener
extends VODListener {
    public static void main(String[] args) throws IllegalArgumentException, ClassNotFoundException, IOException, IllegalAccessException, NoSuchFieldException, InterruptedException {
        HttpServer server = HttpServer.create(new InetSocketAddress(8000), 0);
        server.setExecutor(Executors.newFixedThreadPool(50));
        server.createContext("/StreamCreate", new getStream());
        server.createContext("/StreamExtracter", new MyGet());
        server.createContext("/getInterface", new getInter());
        server.createContext("/StreamModify", new rowEdit());
        server.createContext("/StreamControl", new conStream());
        server.createContext("/RStreamControl", new conRstream());
        server.createContext("/StreamDelete", new deleteStream());
        server.createContext("/RestartStream", new restartStream());
        server.createContext("/getDVBInfo", new getDVBInfo());
        server.createContext("/getserver", new getserver());
        server.createContext("/getInputStatus", new getInputStatus());
        server.createContext("/getInputDetail", new getInputDetail());
        server.createContext("/InputServiceControl", new conInputService());
        server.createContext("/vod/createContent", new VODListener.createContent());
        server.createContext("/interfaceStatus", new interfaceStatus());
        try {
            server.start();
            System.out.println("Server started on port 8000");
        }
        catch (Exception e) {
            e.printStackTrace();
            System.err.println("HttpServer failed to start: " + e.getMessage());
        }
        System.out.println("server Started");
    }

    private static void makeStreamPresetForUDPandDRM(String Presetlocation, String input_ip, String output_ip, String channel_type2) {
        try {
            BufferedWriter writer = null;
            System.out.println(Presetlocation + " " + input_ip + " " + output_ip + " " + channel_type2);
            writer = new BufferedWriter(new FileWriter(Presetlocation + "/preset_" + channel_type2));
            writer.write("#! /bin/bash \n\n\n");
            writer.write("Ridsys-RStreamer_Engine-1.6 -v -m --synchronous-log -I ip -l " + input_ip + " -r $INPUT_URL   \\\n");
            writer.write("-P scrambler --cw 0000000000000001 --partial-scrambling 7 \"$SERVICE_ID\"  \\\n");
            writer.write(" -P pmt --add-ca-descriptor \"$CAS_ID/$CAS_PID\" \\\n");
            writer.write(" -P svrename --provider \"$PROVIDER\" \\\n");
            writer.write(" -P analyze -i 30 -o report.txt  \\\n");
            writer.write(" -O ip -l " + output_ip + " $OUTPUT_URL  \\\n");
            writer.write("</dev/null > /dev/null 2>&1 2>file.txt & echo $! > $STREAM_PID_PATH  \n");
            writer.close();
            new LinuxCommandExecutor().givePermission(Presetlocation + "/preset_" + channel_type2);
        }
        catch (Exception e) {
            System.out.println("Exception at Make Script:" + e.getMessage());
        }
    }

    private static void makeRStreamForUdpandDRM(String location, int stream_id, String inputurl, String outputurl, String channel_name, String channel_type2, boolean drm_status, boolean catchup_on, int service_id) {
        try {
            BufferedWriter writer = null;
            try {
                writer = new BufferedWriter(new FileWriter(location + "/RStream"));
            }
            catch (Exception e) {
                System.out.println("location error:" + e.getMessage());
                new LinuxCommandExecutor().makeDirectory(location);
                if (drm_status) {
                    new LinuxCommandExecutor().makeDirectory(location + "/playlist");
                }
                writer = new BufferedWriter(new FileWriter(location + "/RStream"));
            }
            writer.write("#!/bin/bash\n");
            writer.write("\n");
            writer.write("# Stream " + stream_id + "\n");
            writer.write("\n");
            writer.write("export STREAM_NAME=\"stream" + stream_id + "\"\n");
            writer.write("export STREAM_PID_PATH=\"/home/user/RIDSYSPACKAGE/pid/$STREAM_NAME-pid\"\n");
            writer.write("export INPUT_URL=\"" + inputurl + "\"\n");
            writer.write("export CH_NAME=\"" + channel_name + "\"\n");
            writer.write("export OUTPUT_URL=\"" + outputurl + "\"\n");
            writer.write("export CAS_ID=\"0x4b19\" \n");
            writer.write("export CAS_PID=\"0x03e8\" \n");
            writer.write("export PROVIDER=\"MR RIDSYS Pvt Ltd\" \n");
            writer.write("SERVICE_ID=\"" + service_id + "\" \n");
            writer.write("$source /home/user/RIDSYSPACKAGE/riptv/live/stream" + stream_id + "/preset_sd \n");
            writer.write("\n");
            String p = "";
            p = catchup_on & drm_status ? location + "/preset_catchup_drm_new_test" : (drm_status ? location + "/preset_drm" : (catchup_on & !drm_status ? location + "//preset_catchup" : location + "/preset_" + channel_type2));
            writer.close();
            new LinuxCommandExecutor().givePermission(location + "/RStream");
        }
        catch (Exception e) {
            System.out.println("Exception at Make Script:" + e.getMessage());
        }
    }

    public static void makeAutoscriptfileForUDP1(String location) {
        try {
            BufferedWriter writer = null;
            writer = new BufferedWriter(new FileWriter(location));
            writer.write("#!/bin/sh \n\n");
            writer.write("get_stream_name=$(basename \"$0\")   \n\n");
            writer.write("STREAM_NAME=$(echo \"$get_stream_name\")   \n\n");
            writer.write("PATH_TO_JAR=/home/user/RIDSYSPACKAGE/riptv/live/$STREAM_NAME  \n");
            writer.write("STREAM_PID_PATH=/home/user/RIDSYSPACKAGE/pid/$STREAM_NAME-pid   \n\n");
            writer.write("case $1 in   \n");
            writer.write("    start)   \n");
            writer.write("        echo \"Starting $STREAM_NAME ...\"  \n");
            writer.write("        if [ ! -f $STREAM_PID_PATH ]; then  \n");
            writer.write("            cd $PATH_TO_JAR  \n");
            writer.write("            nohup ./RStream </dev/null > /dev/null 2>&1 & echo $! > $STREAM_PID_PATH \n");
            writer.write("            echo \"$STREAM_NAME started ...\"  \n");
            writer.write("        else  \n");
            writer.write("            echo \"$STREAM_NAME is already running ...\"  \n");
            writer.write("        fi  \n");
            writer.write("    ;;  \n");
            writer.write("    stop) \n");
            writer.write("        if [ -f $STREAM_PID_PATH ]; then  \n");
            writer.write("            PID=$(cat $STREAM_PID_PATH);  \n");
            writer.write("            echo \"$STREAM_NAME stoping ...\"  \n");
            writer.write("            kill $PID;  \n");
            writer.write("            echo \"$STREAM_NAME stopped ...\"  \n");
            writer.write("            rm $STREAM_PID_PATH \n");
            writer.write("         else  \n");
            writer.write("            echo \"$STREAM_NAME is not running ...\"  \n");
            writer.write("        fi  \n");
            writer.write("     ;; \n");
            writer.write("     restart)  \n");
            writer.write("        if [ -f $STREAM_PID_PATH ]; then  \n");
            writer.write("            PID=$(cat $STREAM_PID_PATH);  \n");
            writer.write("            echo \"$STREAM_NAME stopping ...\";  \n");
            writer.write("            kill $PID; \n");
            writer.write("            echo \"$STREAM_NAME stopped ...\"; \n");
            writer.write("            rm $STREAM_PID_PATH  \n");
            writer.write("            echo \"$STREAM_NAME starting ...\" \n");
            writer.write("            cd $PATH_TO_JAR  \n");
            writer.write("            nohup ./RStream /tmp 2>> /dev/null >> /dev/null & \n");
            writer.write("                        echo $! > $STREAM_PID_PATH \n");
            writer.write("            echo \"$STREAM_NAME started ...\" \n");
            writer.write("        else \n");
            writer.write("            echo \"$STREAM_NAME is not running ...\"  \n");
            writer.write("        fi  \n");
            writer.write("     ;; esac  \n");
            writer.close();
            new LinuxCommandExecutor().givePermission(location);
        }
        catch (Exception e) {
            System.out.println("Exception at Make AutoScript:" + e.getMessage());
        }
    }

    public static void makeRStreamForUdpRecentDRM(boolean isInterbase, String location, String presetpath, int stream_id, String inputurl, String outputurl, String inputip, String outputip, String channel_name, String channel_type2, boolean drm_status, boolean catchup_on, int programno, boolean ismpts, String oldchannelname) {
        try {
            BufferedWriter writer = null;
            try {
                writer = new BufferedWriter(new FileWriter(location + "/RStream"));
            }
            catch (Exception e) {
                writer = new BufferedWriter(new FileWriter(location + "/RStream"));
            }
            writer.write("#!/bin/bash\n");
            writer.write("\n");
            writer.write("# Stream " + stream_id + "\n");
            writer.write("\n");
            writer.write("export STREAM_NAME=\"stream" + stream_id + "\"\n");
            writer.write("export STREAM_PID_PATH=\"/home/user/RIDSYSPACKAGE/pid/$STREAM_NAME-pid\"\n");
            writer.write("export INPUT_INTERFACE=\"" + inputip + "\"\n");
            writer.write("export OUTPUT_INTERFACE=\"" + outputip + "\"\n");
            writer.write("export INPUT_URL=\"" + inputurl + "\"\n");
            writer.write("export OUTPUT_URL=\"" + outputurl + "\"\n");
            writer.write("export CH_NAME=\"" + oldchannelname + "\"\n");
            writer.write("export OUT_CH_NAME=\"" + channel_name + "\"\n");
            String p = "";
            if (!drm_status) {
                if (ismpts) {
                    writer.write("export SERVICE_ID=\"" + programno + "\"\n");
                    writer.write("\n");
                    p = presetpath + "Streaming_file_mpts";
                } else {
                    writer.write("\n");
                    p = presetpath + "Streaming_file";
                }
            } else if (ismpts) {
                writer.write("export SERVICE_ID=\"" + programno + "\"\n");
                writer.write("\n");
                p = presetpath + "RStreaming_file_mpts";
            } else {
                writer.write("export SERVICE_ID=\"" + programno + "\"\n");
                writer.write("\n");
                p = presetpath + "RStreaming_file";
            }
            if (isInterbase) {
                p = p + "_with_interface";
            }
            writer.write("$source " + p + "\n");
            writer.close();
            new LinuxCommandExecutor().givePermission(location + "/RStream");
        }
        catch (Exception e) {
            System.out.println("Exception at Make Script:" + e.getMessage());
        }
    }

    public static void Rstream(String location, int stream_id, String inputurl, String outputurl, String inputip, String outputip, String channel_name, int programno, boolean ismpts, String oldchannelname, String streamtype) {
        try {
            System.out.println(location);
            BufferedWriter writer = null;
            try {
                writer = new BufferedWriter(new FileWriter(location + "/RStream"));
            }
            catch (Exception e) {
                writer = new BufferedWriter(new FileWriter(location + "/RStream"));
            }
            writer.write("#!/bin/bash\n");
            writer.write("\n");
            writer.write("# Stream " + stream_id + "\n");
            writer.write("\n");
            writer.write("export STREAM_NAME=\"stream" + stream_id + "\"\n");
            writer.write("export STREAM_PID_PATH=\"/home/user/RIDSYSPACKAGE/pid/$STREAM_NAME-pid\"\n");
            writer.write("export INPUT_INTERFACE=\"" + inputip + "\"\n");
            writer.write("export OUTPUT_INTERFACE=\"" + outputip + "\"\n");
            writer.write("export INPUT_URL=\"" + inputurl + "\"\n");
            writer.write("export OUTPUT_URL=\"" + outputurl + "\"\n");
            writer.write("export CH_NAME=\"" + oldchannelname + "\"\n");
            writer.write("export OUT_CH_NAME=\"" + channel_name + "\"\n\n");
            writer.write("export FUNCTION_TO_CALL=\"" + streamtype + "\"\n");
            writer.write("$source /home/user/RIDSYSPACKAGE/riptv/live/Streaming_file\n");
            writer.close();
            new LinuxCommandExecutor().givePermission(location + "/RStream");
        }
        catch (Exception e) {
            System.out.println("Exception at Make Script:" + e.getMessage());
        }
    }

    public static void fileWriter(String stream) {
        try {
            IPTVListener.fileWriterRemove(stream);
            new LinuxCommandExecutor().copyActiveStream("/usr/local/bin/Active_Stream", "/home/user/Active_Stream");
            new LinuxCommandExecutor().giveWritePermission("/home/user/Active_Stream");
            BufferedWriter writer = null;
            writer = new BufferedWriter(new FileWriter("/home/user/Active_Stream", true));
            writer.write(stream.concat("\n"));
            writer.close();
            new LinuxCommandExecutor().copyActiveStream("/home/user/Active_Stream", "/usr/local/bin/Active_Stream");
            new LinuxCommandExecutor().givePermission("/usr/local/bin/Active_Stream");
        }
        catch (Exception e) {
            System.out.println("Exception at file write:" + e.getMessage());
        }
    }

    public static void fileWriterRemove(String stream) {
        try {
            new LinuxCommandExecutor().copyActiveStream("/usr/local/bin/Active_Stream", "/home/user/Active_Stream");
            new LinuxCommandExecutor().giveWritePermission("/home/user/Active_Stream");
            Path path = Paths.get("/home/user/Active_Stream", new String[0]);
            String content = new String(Files.readAllBytes(path));
            content = content.replace(stream, "\n");
            Files.write(path, content.getBytes(), new OpenOption[0]);
            new LinuxCommandExecutor().copyActiveStream("/home/user/Active_Stream", "/usr/local/bin/Active_Stream");
            new LinuxCommandExecutor().givePermission("/usr/local/bin/Active_Stream");
        }
        catch (Exception e) {
            System.out.println("Exception at file write:" + e.getMessage());
        }
    }

    static class interfaceStatus
    implements HttpHandler {
        interfaceStatus() {
        }

        @Override
        public void handle(HttpExchange t) throws IOException {
            String line;
            System.out.println("client connected..");
            InputStream intp = t.getRequestBody();
            BufferedReader br = new BufferedReader(new InputStreamReader(intp));
            StringBuilder builder = new StringBuilder();
            String data = "";
            while ((line = br.readLine()) != null) {
                builder.append(line);
            }
            data = builder.toString();
            Object obj = null;
            JSONObject json_data = null;
            try {
                JSONParser parser = new JSONParser();
                obj = parser.parse(data);
                json_data = (JSONObject)obj;
            }
            catch (Exception parser) {
                // empty catch block
            }
            System.out.println("json" + json_data);
            String eth = json_data.get((Object)"eth").toString();
            String response = "";
            try {
                response = interfaceStatus.commandExe(eth);
            }
            catch (Exception exception) {
                // empty catch block
            }
            System.out.println("response completed--" + response);
            t.sendResponseHeaders(200, response.length());
            OutputStream os = t.getResponseBody();
            os.write(response.getBytes());
            os.close();
        }

        public static String commandExe(String eth) {
            System.out.println("interface status----------------------------------------------------------------");
            String response = "DOWN";
            try {
                ProcessBuilder processBuilder = new ProcessBuilder(new String[0]);
                processBuilder.command("bash", "-c", "ip link show dev " + eth + " | grep -oP '(?<=state )\\w+'\n");
                Process process = processBuilder.start();
                BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
                String line = "";
                while ((line = reader.readLine()) != null) {
                    response = line;
                }
            }
            catch (Exception e) {
                return "DOWN";
            }
            return response;
        }
    }

    static class getInputDetail
    implements HttpHandler {
        getInputDetail() {
        }

        @Override
        public void handle(HttpExchange t) throws IOException {
            String line;
            System.out.println("client connected..");
            InputStream intp = t.getRequestBody();
            BufferedReader br = new BufferedReader(new InputStreamReader(intp));
            StringBuilder builder = new StringBuilder();
            String data = "";
            while ((line = br.readLine()) != null) {
                builder.append(line);
            }
            data = builder.toString();
            Object obj = null;
            JSONObject json_data = null;
            try {
                JSONParser parser = new JSONParser();
                obj = parser.parse(data);
                json_data = (JSONObject)obj;
            }
            catch (Exception parser) {
                // empty catch block
            }
            System.out.println("json" + json_data);
            String udp = json_data.get((Object)"udp").toString();
            String response = "";
            try {
                response = this.getInputDetail(udp);
            }
            catch (InterruptedException ex) {
                Logger.getLogger(IPTVListener.class.getName()).log(Level.SEVERE, null, ex);
            }
            System.out.println("response--" + response);
            t.sendResponseHeaders(200, response.length());
            OutputStream os = t.getResponseBody();
            os.write(response.getBytes());
            os.close();
        }

        public String getInputDetail(String udp) throws InterruptedException {
            System.out.println("input information----------------------------------------------------------------");
            String json_string = "{";
            try {
                System.out.println("udp is---" + udp);
                ProcessBuilder processBuilder = new ProcessBuilder(new String[0]);
                processBuilder.command("bash", "-c", "timeout 7 Ridsys-RStreamer_Engine-1.6 -I ip " + udp + " -P until --seconds 1 -P analyze --json -O drop");
                Process process = processBuilder.start();
                BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
                System.out.println("inputstream---" + process.getInputStream() + "   " + reader.read());
                String line = "";
                while ((line = reader.readLine()) != null) {
                    json_string = json_string + line;
                }
                System.out.println(json_string);
            }
            catch (Exception e) {
                System.out.println("Exception at run:" + e.getMessage());
            }
            return json_string;
        }

        public boolean scriptExe(String scriptPath) throws IOException, InterruptedException {
            boolean status = false;
            try {
                String line;
                ProcessBuilder pb = new ProcessBuilder("/bin/bash", scriptPath);
                Process process = pb.start();
                InputStream inputStream = process.getInputStream();
                BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));
                String output = null;
                while ((line = reader.readLine()) != null) {
                    System.out.println("line is ----" + line);
                    output = line;
                }
                if (output.contains("0")) {
                    status = false;
                } else if (output.contains("1")) {
                    status = true;
                    System.out.println(status);
                }
            }
            catch (Exception e) {
                System.out.println("Exception at scrpt: " + e);
            }
            return status;
        }
    }

    static class getInputStatus
    implements HttpHandler {
        getInputStatus() {
        }

        @Override
        public void handle(HttpExchange t) throws IOException {
            String line;
            System.out.println("client connected..");
            InputStream intp = t.getRequestBody();
            BufferedReader br = new BufferedReader(new InputStreamReader(intp));
            StringBuilder builder = new StringBuilder();
            String data = "";
            while ((line = br.readLine()) != null) {
                builder.append(line);
            }
            data = builder.toString();
            Object obj = null;
            JSONObject json_data = null;
            try {
                JSONParser parser = new JSONParser();
                obj = parser.parse(data);
                json_data = (JSONObject)obj;
            }
            catch (Exception parser) {
                // empty catch block
            }
            System.out.println("json" + json_data);
            String protocol = json_data.get((Object)"protocol").toString();
            String udp = json_data.get((Object)"udp").toString();
            String path = json_data.get((Object)"path").toString();
            String response = "";
            try {
                response = String.valueOf(this.getInputStatusForUdp(path, protocol, udp));
            }
            catch (InterruptedException ex) {
                Logger.getLogger(IPTVListener.class.getName()).log(Level.SEVERE, null, ex);
            }
            System.out.println("response--" + response);
            t.sendResponseHeaders(200, response.length());
            OutputStream os = t.getResponseBody();
            os.write(response.getBytes());
            os.close();
        }

        public boolean getInputStatusForUdp(String path, String protocol, String udp) throws InterruptedException {
            System.out.println("input status----------------------------------------------------------------");
            boolean status = false;
            String oldprotocol = "";
            String oldurl = "";
            String newurl = "";
            try {
                File file = new File(path);
                Scanner scanner = new Scanner(file);
                String fileContents = "";
                while (scanner.hasNextLine()) {
                    fileContents = fileContents + scanner.nextLine() + "\n";
                }
                String[] s = fileContents.split("\n");
                int a = 0;
                for (String ss : s) {
                    if (ss.contains("PROTOCOL")) {
                        System.out.println(ss);
                        oldprotocol = ss;
                        oldprotocol = oldprotocol.substring(oldprotocol.lastIndexOf("=") + 1, oldprotocol.length());
                        System.out.println("oldpro: " + oldprotocol);
                    }
                    if (ss.contains("INPUT_URL")) {
                        System.out.println(ss);
                        oldurl = ss;
                        oldurl = oldurl.substring(oldurl.lastIndexOf("=") + 1, oldurl.length());
                        newurl = protocol.equals("ip") ? udp.substring(6, udp.length()) : (protocol.equals("http") ? udp : udp.substring(6, udp.length()));
                        System.out.println("oldurl: " + oldurl);
                    }
                    ++a;
                }
                scanner.close();
                fileContents = fileContents.replace(oldurl, "\"" + newurl + "\"");
                fileContents = fileContents.replace(oldprotocol, "\"" + protocol + "\"");
                System.out.println(fileContents);
                FileWriter writer = new FileWriter(file);
                writer.write(fileContents);
                writer.close();
                status = this.scriptExe(path);
                System.out.println("----------------------------------------finished------------------------------------");
            }
            catch (IOException e) {
                System.out.println("An error occurred: " + e.getMessage());
                e.printStackTrace();
            }
            return status;
        }

        public boolean scriptExe(String scriptPath) throws IOException, InterruptedException {
            boolean status = false;
            try {
                String line;
                ProcessBuilder pb = new ProcessBuilder("/bin/bash", scriptPath);
                Process process = pb.start();
                InputStream inputStream = process.getInputStream();
                BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));
                String output = null;
                while ((line = reader.readLine()) != null) {
                    System.out.println("line is ----" + line);
                    output = line;
                }
                if (output.contains("0")) {
                    status = false;
                } else if (output.contains("1")) {
                    status = true;
                    System.out.println(status);
                }
            }
            catch (Exception e) {
                System.out.println("Exception at scrpt: " + e);
            }
            return status;
        }
    }

    static class getserver
    implements HttpHandler {
        getserver() {
        }

        @Override
        public void handle(HttpExchange t) throws IOException {
            System.out.println("server connected..");
            getserver sp = new getserver();
            String response = sp.getsecserver();
            t.sendResponseHeaders(200, response.getBytes().length);
            OutputStream os = t.getResponseBody();
            os.write(response.getBytes());
            os.close();
        }

        public String getsecserver() {
            ArrayList<String> output = new ArrayList<String>();
            String jsontext = null;
            try {
                System.out.println("get server----------------------------------------------------------------");
                ProcessBuilder processBuilder = new ProcessBuilder(new String[0]);
                ArrayList<String> SYSTEM = new ArrayList<String>();
                SYSTEM.add("free -m | awk 'NR==2{printf \"%.2f%%\\t\\t\", $3*100/$2 }'");
                SYSTEM.add("top -bn1 | grep load | awk '{printf \"%.2f%%\\t\\t\\n\", $(NF-2)}'");
                SYSTEM.add("df -h | awk '$NF==\"/\"{printf \"%s\\t\\t\", $5}'");
                for (int i = 0; i < SYSTEM.size(); ++i) {
                    String line;
                    processBuilder.command("bash", "-c", (String)SYSTEM.get(i));
                    Process process = processBuilder.start();
                    BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
                    while ((line = reader.readLine()) != null) {
                        output.add(line);
                        System.out.println(line);
                    }
                }
                ArrayList lst = new ArrayList();
                HashMap map = new HashMap();
                map.put("MEMORY", output.get(0));
                map.put("DISK", output.get(1));
                map.put("CPU", output.get(2));
                lst.add(map);
                jsontext = JSONValue.toJSONString(lst);
                System.out.println(jsontext);
            }
            catch (IOException e) {
                System.out.println("Exception at :" + e.getMessage());
            }
            return jsontext;
        }
    }

    static class rowEdit
    implements HttpHandler {
        private List<channels> channellist;
        private int id;
        private channels cha_obj;

        rowEdit() {
        }

        public channels getCha_obj() {
            return this.cha_obj;
        }

        public void setCha_obj(channels cha_obj) {
            this.cha_obj = cha_obj;
        }

        public channels getCh_obj() {
            return this.cha_obj;
        }

        public void setCh_obj(channels ch_obj) {
            this.cha_obj = ch_obj;
        }

        public int getId() {
            return this.id;
        }

        public void setId(int id) {
            this.id = id;
        }

        public List<channels> getChannellist() {
            return this.channellist;
        }

        public void setChannellist(List<channels> channellist) {
            this.channellist = channellist;
        }

        @Override
        public void handle(HttpExchange t) {
            try {
                String line;
                System.out.println("Stream edit----------------------------------------------------------------");
                InputStream intp = t.getRequestBody();
                this.cha_obj = new channels();
                BufferedReader br = new BufferedReader(new InputStreamReader(intp));
                StringBuilder builder = new StringBuilder();
                String data = "";
                while ((line = br.readLine()) != null) {
                    builder.append(line);
                }
                data = builder.toString();
                Object obj = null;
                JSONObject json_data = null;
                try {
                    JSONParser parser = new JSONParser();
                    obj = parser.parse(data);
                    json_data = (JSONObject)obj;
                }
                catch (Exception parser) {
                    // empty catch block
                }
                System.out.println("json" + json_data);
                try {
                    this.cha_obj.setUdp_url(json_data.get((Object)"udpurl").toString());
                    this.cha_obj.setProgram_no(Integer.parseInt(json_data.get((Object)"program_number").toString()));
                    if (json_data.get((Object)"oldchannelname") == null || json_data.get((Object)"oldchannelname").toString().equals("")) {
                        this.cha_obj.setInput_channel_name(json_data.get((Object)"channelname").toString());
                    } else {
                        this.cha_obj.setInput_channel_name(json_data.get((Object)"oldchannelname").toString());
                    }
                    this.cha_obj.setChannel_name(json_data.get((Object)"channelname").toString());
                    this.cha_obj.setStream_location(json_data.get((Object)"stream_location").toString());
                    this.cha_obj.setId(Integer.parseInt(json_data.get((Object)"id").toString()));
                    this.cha_obj.setIsMPTS(Boolean.parseBoolean(json_data.get((Object)"isMPTS").toString()));
                    this.cha_obj.setService_location(json_data.get((Object)"service_location").toString());
                    this.cha_obj.setUrl(json_data.get((Object)"url").toString());
                    if (json_data.get((Object)"inputip") == null || json_data.get((Object)"inputip").toString().equals("")) {
                        this.cha_obj.setInputip("");
                    } else {
                        this.cha_obj.setInputip(json_data.get((Object)"inputip").toString());
                    }
                    if (json_data.get((Object)"outputip") == null || json_data.get((Object)"outputip").toString().equals("")) {
                        this.cha_obj.setOutputip("");
                    } else {
                        this.cha_obj.setOutputip(json_data.get((Object)"outputip").toString());
                    }
                    this.cha_obj.setStreamtype(json_data.get((Object)"Streamtype").toString());
                    this.cha_obj.setClienttype(json_data.get((Object)"clienttype").toString());
                    this.cha_obj.setEpg_id(Integer.parseInt(json_data.get((Object)"epgid").toString()));
                    this.cha_obj.setEpg_id2(Integer.parseInt(json_data.get((Object)"epgid2").toString()));
                    this.cha_obj.setStatus(Boolean.parseBoolean(json_data.get((Object)"status").toString()));
                    this.cha_obj.setIs_drm(Boolean.parseBoolean(json_data.get((Object)"isdrm").toString()));
                    System.out.println("list " + this.cha_obj.getLst());
                }
                catch (Exception e) {
                    System.out.println("Exception :" + e);
                }
                String response = this.onRowEdit_channel();
                System.out.println("response" + response);
                t.sendResponseHeaders(200, response.getBytes().length);
                OutputStream os = t.getResponseBody();
                os.write(response.getBytes());
                os.close();
            }
            catch (Exception e) {
                System.out.println("exception is" + e);
            }
        }

        public String onRowEdit_channel() {
            String status = "Success";
            try {
                if (!this.cha_obj.getStreamtype().equals("url")) {
                    this.stopService(this.cha_obj.getId());
                    new LinuxCommandExecutor().removeFolder(this.cha_obj.getStream_location() + "stream" + this.cha_obj.getId() + "/");
                    this.fileWriterRemove();
                    StringBuilder inurl = new StringBuilder(this.cha_obj.getUdp_url());
                    StringBuilder outurl = new StringBuilder(this.cha_obj.getUrl());
                    if (this.cha_obj.getStreamtype().equals("preset_udp_drm") || this.cha_obj.getStreamtype().equals("preset_udp") || this.cha_obj.getStreamtype().equals("preset_mpts_udp_drm") || this.cha_obj.getStreamtype().equals("preset_mpts_udp")) {
                        inurl = new StringBuilder(this.cha_obj.getUdp_url().substring(6, this.cha_obj.getUdp_url().length()));
                        outurl = new StringBuilder(this.cha_obj.getUrl().substring(6, this.cha_obj.getUrl().length()));
                    } else if (this.cha_obj.getStreamtype().equals("preset_hls_to_udp") || this.cha_obj.getStreamtype().equals("preset_hls_to_udp_drm")) {
                        outurl = new StringBuilder(this.cha_obj.getUrl().substring(6, this.cha_obj.getUrl().length()));
                    } else if (this.cha_obj.getStreamtype().equals("preset_hls") || this.cha_obj.getStreamtype().equals("preset_hls_drm")) {
                        inurl = new StringBuilder(this.cha_obj.getUdp_url().substring(6, this.cha_obj.getUdp_url().length()));
                    }
                    if (this.cha_obj.getClienttype() != null && !this.cha_obj.getClienttype().equals("")) {
                        new LinuxCommandExecutor().makeDirectory(this.cha_obj.getStream_location() + "stream" + this.cha_obj.getId());
                        if (this.cha_obj.getClienttype().equalsIgnoreCase("file")) {
                            IPTVListener.Rstream(this.cha_obj.getStream_location() + "/stream" + this.cha_obj.getId(), this.cha_obj.getId(), inurl.toString(), outurl.toString(), this.cha_obj.getInputip(), this.cha_obj.getOutputip(), this.cha_obj.getChannel_name(), this.cha_obj.getProgram_no(), this.cha_obj.isIsMPTS(), this.cha_obj.getInput_channel_name(), this.cha_obj.getStreamtype());
                            IPTVListener.makeAutoscriptfileForUDP1(this.cha_obj.getService_location() + "stream" + this.cha_obj.getId());
                        } else if (this.cha_obj.getClienttype().equalsIgnoreCase("ffprobe")) {
                            if (this.cha_obj.isIs_drm()) {
                                new LinuxCommandExecutor().makeDirectory(this.cha_obj.getStream_location() + "/stream" + this.cha_obj.getId() + "/playlist");
                                FfprobeStreamFiles.Rstream_drm(this.cha_obj.getStream_location() + "/stream" + this.cha_obj.getId(), "stream" + this.cha_obj.getId(), inurl.toString(), this.cha_obj.getChannel_name(), this.cha_obj.getInputip(), this.cha_obj.getInput_channel_name());
                                FfprobeStreamFiles.Preset_drm(this.cha_obj.getStream_location() + "/stream" + this.cha_obj.getId());
                                FfprobeStreamFiles.KeyGenerator(this.cha_obj.getStream_location() + "/stream" + this.cha_obj.getId());
                                FfprobeStreamFiles.makeServiceDRMFile(this.cha_obj.getService_location() + "stream" + this.cha_obj.getId());
                            } else {
                                FfprobeStreamFiles.Rstream(this.cha_obj.getStream_location() + "/stream" + this.cha_obj.getId(), "stream" + this.cha_obj.getId(), inurl.toString(), this.cha_obj.getChannel_name(), this.cha_obj.getInputip(), this.cha_obj.getInput_channel_name());
                                FfprobeStreamFiles.Preset(this.cha_obj.getStream_location() + "/stream" + this.cha_obj.getId());
                                IPTVListener.makeAutoscriptfileForUDP1(this.cha_obj.getService_location() + "stream" + this.cha_obj.getId());
                            }
                        }
                    }
                    new LinuxCommandExecutor().moveServiceFile(this.cha_obj.getId());
                    new LinuxCommandExecutor().removeFile(this.cha_obj.getService_location() + "stream" + this.cha_obj.getId());
                }
                if (this.cha_obj.isStatus()) {
                    this.roweditRestartStream(this.cha_obj.getId());
                    IPTVListener.fileWriter("stream" + this.cha_obj.getId());
                }
                if (this.cha_obj.getEpg_id() != this.cha_obj.getEpg_id2()) {
                    HashMap<String, Object> m = new HashMap<String, Object>();
                    m.put("db", "iptv");
                    m.put("channel_id", this.cha_obj.getId());
                    m.put("epg_id", this.cha_obj.getEpg_id());
                    String jsontext = JSONValue.toJSONString(m);
                    String cas_responce = this.sendCommand(this.cha_obj.getAccess_ip(), jsontext);
                    System.out.println("cas responce:" + cas_responce);
                }
            }
            catch (Exception e) {
                System.out.println("VOD Category row edit exception:" + e.getMessage());
            }
            return status;
        }

        private void makeRStreamForUdpandDRM(String location, int stream_id, String inputurl, String outputurl, String channel_name, String channel_type2, boolean drm_status, boolean catchup_on, int service_id) {
            try {
                BufferedWriter writer = null;
                try {
                    writer = new BufferedWriter(new FileWriter(location + "/RStream"));
                }
                catch (Exception e) {
                    System.out.println("location error:" + e.getMessage());
                    new LinuxCommandExecutor().makeDirectory(location);
                    if (drm_status) {
                        new LinuxCommandExecutor().makeDirectory(location + "/playlist");
                    }
                    writer = new BufferedWriter(new FileWriter(location + "/RStream"));
                }
                writer.write("#!/bin/bash\n");
                writer.write("\n");
                writer.write("# Stream " + stream_id + "\n");
                writer.write("\n");
                writer.write("export STREAM_NAME=\"stream" + stream_id + "\"\n");
                writer.write("export STREAM_PID_PATH=\"/home/user/RIDSYSPACKAGE/pid/$STREAM_NAME-pid\"\n");
                writer.write("export INPUT_URL=\"" + inputurl + "\"\n");
                writer.write("export CH_NAME=\"" + channel_name + "\"\n");
                writer.write("export OUTPUT_URL=\"" + outputurl + "\"\n");
                writer.write("export CAS_ID=\"0x4b19\" \n");
                writer.write("export CAS_PID=\"0x03e8\" \n");
                writer.write("export PROVIDER=\"MR RIDSYS Pvt Ltd\" \n");
                writer.write("SERVICE_ID=\"" + service_id + "\" \n");
                writer.write("$source /home/user/RIDSYSPACKAGE/riptv/live/stream" + stream_id + "/preset_sd \n");
                writer.write("\n");
                String p = "";
                p = catchup_on & drm_status ? location + "/preset_catchup_drm_new_test" : (drm_status ? location + "/preset_drm" : (catchup_on & !drm_status ? location + "//preset_catchup" : location + "/preset_" + channel_type2));
                writer.close();
                new LinuxCommandExecutor().givePermission(location + "/RStream");
            }
            catch (Exception e) {
                System.out.println("Exception at Make Script:" + e.getMessage());
            }
        }

        public void makeStreamPresetForUDP2(String Presetlocation, String input_ip, String output_ip, String channel_type2) {
            try {
                BufferedWriter writer = null;
                System.out.println(Presetlocation + " " + input_ip + " " + output_ip + " " + channel_type2);
                writer = new BufferedWriter(new FileWriter(Presetlocation + "/preset_" + channel_type2));
                writer.write("#! /bin/bash \n\n\n");
                writer.write("Ridsys-RStreamer_Engine-1.6 -v -m --synchronous-log -I ip -l " + input_ip + " -r $INPUT_URL   \\\n");
                writer.write(" -P pmt --add-ca-descriptor \"$CAS_ID/$CAS_PID\" \\\n");
                writer.write(" -P svrename --provider \"$PROVIDER\" \\\n");
                writer.write(" -P analyze -i 30 -o report.txt  \\\n");
                writer.write(" -O ip -l " + output_ip + " $OUTPUT_URL  \\\n");
                writer.write("</dev/null > /dev/null 2>&1 2>file.txt & echo $! > $STREAM_PID_PATH  \n");
                writer.close();
                new LinuxCommandExecutor().givePermission(Presetlocation + "/preset_" + channel_type2);
            }
            catch (Exception e) {
                System.out.println("Exception at Make Script:" + e.getMessage());
            }
        }

        public void makeRStreamForUdp1(String location, int stream_id, String inputurl, String outputurl, String channel_name, String channel_type2, boolean drm_status, boolean catchup_on) {
            try {
                System.out.println(location + " " + stream_id + " " + inputurl + " " + outputurl + " " + channel_name + " " + channel_type2);
                BufferedWriter writer = null;
                try {
                    writer = new BufferedWriter(new FileWriter(location + "/RStream"));
                }
                catch (Exception e) {
                    System.out.println("location error:" + e.getMessage());
                    new LinuxCommandExecutor().makeDirectory(location);
                    if (drm_status) {
                        new LinuxCommandExecutor().makeDirectory(location + "/playlist");
                    }
                    writer = new BufferedWriter(new FileWriter(location + "/RStream"));
                }
                writer.write("#!/bin/bash\n");
                writer.write("\n");
                writer.write("# Stream " + stream_id + "\n");
                writer.write("\n");
                writer.write("export STREAM_NAME=\"stream" + stream_id + "\"\n");
                writer.write("export STREAM_PID_PATH=\"/home/user/RIDSYSPACKAGE/pid/$STREAM_NAME-pid\"\n");
                writer.write("export INPUT_URL=\"" + inputurl + "\"\n");
                writer.write("export CH_NAME=\"" + channel_name + "\"\n");
                writer.write("export OUTPUT_URL=\"" + outputurl + "\"\n");
                writer.write("export CAS_ID=\"0x4b19\" \n");
                writer.write("export CAS_PID=\"0x03e8\" \n");
                writer.write("export PROVIDER=\"MR RIDSYS Pvt Ltd\" \n");
                writer.write("\n");
                String p = "";
                p = catchup_on & drm_status ? location + "/preset_catchup_drm_new_test" : (drm_status ? location + "/preset_drm" : (catchup_on & !drm_status ? location + "/preset_catchup" : location + "/preset_" + channel_type2));
                writer.write("$source " + p + "\n");
                writer.close();
                new LinuxCommandExecutor().givePermission(location + "/RStream");
            }
            catch (Exception e) {
                System.out.println("Exception at Make Script:" + e.getMessage());
            }
        }

        public String stopService(int stream_id) {
            String output = "";
            try {
                String[] commands;
                System.out.println("STREAM ID:" + stream_id);
                for (String c : commands = new String[]{"stream" + stream_id + " stop"}) {
                    Process process = Runtime.getRuntime().exec(c, null, null);
                    BufferedReader in = new BufferedReader(new InputStreamReader(process.getInputStream()));
                    String line = null;
                    while ((line = in.readLine()) != null) {
                        output = output + "\n" + line;
                    }
                }
            }
            catch (Exception e) {
                System.out.println("Exception at stop function:" + e.getMessage());
                output = output + e.getMessage();
            }
            return output;
        }

        public void fileWriterRemove() {
            try {
                BufferedWriter writer = null;
                writer = new BufferedWriter(new FileWriter("/home/user/Active_Stream"));
                for (int i = 0; i < this.cha_obj.getLst().size(); ++i) {
                    System.out.println("cha_obj.getLst().get(i) : " + this.cha_obj.getLst().get(i));
                    writer.write("stream" + this.cha_obj.getLst().get(i) + "\n");
                }
                writer.close();
                new LinuxCommandExecutor().copyActiveStream("/home/user/Active_Stream", "/usr/local/bin/Active_Stream");
                new LinuxCommandExecutor().givePermission("/usr/local/bin/Active_Stream");
            }
            catch (Exception e) {
                System.out.println("Exception at file write:" + e.getMessage());
            }
        }

        public void makeStreamPresetDRM(String Presetlocation, String inter_ip, int audio_count, boolean is_mpts, int program_no) {
            try {
                BufferedWriter writer = null;
                writer = new BufferedWriter(new FileWriter(Presetlocation + "/preset_drm"));
                writer.write("#!/bin/bash\n");
                writer.write("RffmpegTest -threads 3 -c:s webvtt -i \"$INPUT_URL?source=" + inter_ip + "&overrun_nonfatal=1&fifo_size=1000000\" \\\n");
                writer.write(" -g 25 -sc_threshold 0 -aspect 16:9 \\\n");
                writer.write("  -c:v copy \\\n");
                if (!is_mpts) {
                    if (audio_count == 1) {
                        writer.write("  -map 0:0 -map 0:1  \\\n");
                    } else if (audio_count == 2) {
                        writer.write("  -map 0:0 -map 0:1 -map 0:2  \\\n");
                    } else if (audio_count == 3) {
                        writer.write("  -map 0:0 -map 0:1 -map 0:2 -map 0:3  \\\n");
                    } else if (audio_count == 4) {
                        writer.write("  -map 0:0 -map 0:1 -map 0:2 -map 0:3 -map 0:4  \\\n");
                    } else if (audio_count == 5) {
                        writer.write("  -map 0:0 -map 0:1 -map 0:2 -map 0:3 -map 0:4 -map 0:5  \\\n");
                    } else {
                        writer.write("  -map 0:0 -map 0:1  \\\n");
                    }
                    writer.write("  -c:a aac -b:a 128k -ac 2 \\\n");
                    writer.write("  -threads 3 -f hls -hls_time 3 -hls_wrap 15 -hls_key_info_file file.keyinfo \\\n");
                } else {
                    writer.write("  -c:a copy -copy_unknown -c:a aac -b:a 256k -ar 48000 \\\n");
                    writer.write("  -map 0:p:" + program_no + " -threads 4 -f hls -hls_time 2 -hls_wrap 15 -hls_flags periodic_rekey -hls_key_info_file file.keyinfo\\\n");
                }
                writer.write(" \"/home/user/RIDSYSPACKAGE/riptv/live/$STREAM_NAME/manifest.m3u8\" \\\n");
                writer.write("</dev/null > /dev/null 2>&1 & echo $! > $STREAM_PID_PATH");
                writer.close();
                new LinuxCommandExecutor().givePermission(Presetlocation + "/preset_drm");
            }
            catch (Exception e) {
                System.out.println("Exception at Make Script:" + e.getMessage());
            }
        }

        public void makeRStream(String location, int stream_id, String udp_url, String channel_name, String channel_type2, String preset_location, boolean drm_status, boolean catchup_on) {
            try {
                BufferedWriter writer = null;
                try {
                    writer = new BufferedWriter(new FileWriter(location + "/RStream"));
                }
                catch (Exception e) {
                    System.out.println("location error:" + e.getMessage());
                    new LinuxCommandExecutor().makeDirectory(preset_location + "stream" + this.id);
                    if (drm_status) {
                        new LinuxCommandExecutor().makeDirectory(preset_location + "stream" + this.id + "/playlist");
                    }
                    writer = new BufferedWriter(new FileWriter(location + "/RStream"));
                }
                writer.write("#!/bin/bash\n");
                writer.write("\n");
                writer.write("# Stream " + stream_id + "\n");
                writer.write("\n");
                writer.write("export STREAM_NAME=\"stream" + stream_id + "\"\n");
                writer.write("export STREAM_PID_PATH=\"/home/user/RIDSYSPACKAGE/pid/$STREAM_NAME-pid\"\n");
                writer.write("export INPUT_URL=\"" + udp_url + "\"\n");
                writer.write("export CH_NAME=\"" + channel_name + "\"\n");
                writer.write("\n");
                String p = "";
                p = catchup_on & drm_status ? preset_location + "preset_catchup_drm_new_test" : (drm_status ? location + "preset_drm" : (catchup_on & !drm_status ? location + "preset_catchup" : location + "preset_" + channel_type2));
                writer.write("$source " + p + "\n");
                writer.close();
                new LinuxCommandExecutor().givePermission(location + "/RStream");
            }
            catch (Exception e) {
                System.out.println("Exception at Make Script:" + e.getMessage());
            }
        }

        public void makeIndexFile(String location) {
            try {
                BufferedWriter writer = null;
                writer = new BufferedWriter(new FileWriter(location + "/index.m3u8"));
                writer.write("#EXTM3U\n");
                writer.write("#EXT-X-VERSION:3\n");
                writer.write("#EXT-X-STREAM-INF:BANDWIDTH=400000,RESOLUTION=1920x1080,CODECS=\"avc1.64001e,mp4a.40.2\"\n");
                writer.write("manifest.m3u8\n");
                writer.close();
                new LinuxCommandExecutor().givePermission(location + "/index.m3u8");
            }
            catch (Exception e) {
                System.out.println("Exception at Make Script:" + e.getMessage());
            }
        }

        public void makeKeyScript(String location) {
            try {
                BufferedWriter writer = null;
                writer = new BufferedWriter(new FileWriter(location + "/KeyGenerator"));
                writer.write("#!/bin/bash\n");
                writer.write("\n");
                writer.write("source /home/user/RIDSYSPACKAGE/riptv/live/auto_key_generator\n");
                writer.close();
                new LinuxCommandExecutor().givePermission(location + "/KeyGenerator");
            }
            catch (Exception e) {
                System.out.println("Exception at Make Script:" + e.getMessage());
            }
        }

        public void makeServiceDRMUpdated(String service_location) {
            try {
                BufferedWriter writer = null;
                writer = new BufferedWriter(new FileWriter(service_location));
                writer.write("#!/bin/sh\n");
                writer.write("\n");
                writer.write("# HLS_STREAM\n");
                writer.write("\n");
                writer.write("get_stream_name=$(basename \"$0\")\n");
                writer.write("\n");
                writer.write("STREAM_NAME=$(echo \"$get_stream_name\") \n");
                writer.write("STREAM_PID_PATH=/home/user/RIDSYSPACKAGE/pid/$STREAM_NAME-pid\n");
                writer.write("\n");
                writer.write("SERVICE_NAME=RStream\n");
                writer.write("SERVICE_NAME2=KeyGenerator\n");
                writer.write("\n");
                writer.write("PATH_TO=/home/user/RIDSYSPACKAGE/riptv/live/$STREAM_NAME/playlist\n");
                writer.write("PID_PATH_NAME=/home/user/RIDSYSPACKAGE/pid/$STREAM_NAME-pid\n");
                writer.write("\n");
                writer.write("PID_PATH_NAME2=/tmp/$SERVICE_NAME2-pid\n");
                writer.write("\n");
                writer.write("case $1 in\n");
                writer.write("    start)\n");
                writer.write("        echo \"Starting $SERVICE_NAME ...\"\n");
                writer.write("        if [ ! -f $PID_PATH_NAME ]; then\n");
                writer.write("\t    cd $PATH_TO\n");
                writer.write("            nohup ./$SERVICE_NAME /tmp 2>>  /dev/null >> /dev/null & echo $! > $PID_PATH_NAME&\n");
                writer.write("\n");
                writer.write("            nohup ./$SERVICE_NAME2  </dev/null > /dev/null 2>&1 & echo $! > $PID_PATH_NAME2\n");
                writer.write("            echo \"$SERVICE_NAME started ...\"\n");
                writer.write("        else\n");
                writer.write("            echo \"$SERVICE_NAME is already running ...\"\n");
                writer.write("        fi\n");
                writer.write("    ;;\n");
                writer.write("    stop)\n");
                writer.write("        if [ -f $PID_PATH_NAME ]; then\n");
                writer.write("            PID1=$(cat $PID_PATH_NAME);\n");
                writer.write("            PID2=$(cat $STREAM_PID_PATH);\n");
                writer.write("            PID3=$(cat $PID_PATH_NAME2);\n");
                writer.write("\n");
                writer.write("            echo \"$SERVICE_NAME stoping ...\"\n");
                writer.write("#\t    kill $PID1;\n");
                writer.write("\t    kill $PID2;\n");
                writer.write("          kill $PID3;\n");
                writer.write("\n");
                writer.write("            echo \"$SERVICE_NAME stopped ...\"\n");
                writer.write("            rm $PID_PATH_NAME $PID_PATH_NAME2 $STREAM_PID_PATH \n");
                writer.write("        else\n");
                writer.write("            echo \"$SERVICE_NAME is not running ...\"\n");
                writer.write("        fi\n");
                writer.write("    ;;\n");
                writer.write("    restart)\n");
                writer.write("        if [ -f $PID_PATH_NAME ]; then\n");
                writer.write("            PID1=$(cat $PID_PATH_NAME);\n");
                writer.write("            PID2=$(cat $STREAM_PID_PATH);\n");
                writer.write("            PID3=$(cat $PID_PATH_NAME2);\n");
                writer.write("            echo \"$SERVICE_NAME stopping ...\";\n");
                writer.write("\t    kill $PID1;\n");
                writer.write("\t    kill $PID2;\n");
                writer.write("          kill $PID3;\n");
                writer.write("            echo \"$SERVICE_NAME stopped ...\";\n");
                writer.write("            rm $PID_PATH_NAME $STREAM_PID_PATH $PID_PATH_NAME2\n");
                writer.write("            echo \"$SERVICE_NAME starting ...\"\n");
                writer.write("\t    cd $PATH_TO\n");
                writer.write("            nohup ./$SERVICE_NAME /tmp 2>> /dev/null >> /dev/null &\n");
                writer.write("                        echo $! > $PID_PATH_NAME\n");
                writer.write("             nohup ./$SERVICE_NAME2  </dev/null > /dev/null 2>&1 & echo $! > $PID_PATH_NAME2\n");
                writer.write("\n");
                writer.write("            echo \"$SERVICE_NAME started ...\"\n");
                writer.write("        else\n");
                writer.write("            echo \"$SERVICE_NAME is not running ...\"\n");
                writer.write("        fi\n");
                writer.write("    ;;\n");
                writer.write("esac\n");
                writer.close();
                System.out.println("service location:" + service_location);
                new LinuxCommandExecutor().givePermission(service_location);
            }
            catch (Exception e) {
                System.out.println("Exception at Make Script:" + e.getMessage());
            }
        }

        public void makeStreamPreset(String Presetlocation, String inter_ip, String channel_type2, int audio_count, boolean is_mpts, int program_no) {
            try {
                BufferedWriter writer = null;
                writer = new BufferedWriter(new FileWriter(Presetlocation + "/preset_" + channel_type2));
                writer.write("#!/bin/bash \n");
                writer.write("RStreamer_engine_1.5 -re -threads 3 -c:s webvtt -i \"$INPUT_URL?source=" + inter_ip + "&overrun_nonfatal=1&fifo_size=1000000\" \\\n");
                writer.write("  -c:v copy \\\n");
                if (!is_mpts) {
                    if (audio_count == 1) {
                        writer.write("  -map 0:0 -map 0:1  \\\n");
                    } else if (audio_count == 2) {
                        writer.write("  -map 0:0 -map 0:1 -map 0:2  \\\n");
                    } else if (audio_count == 3) {
                        writer.write("  -map 0:0 -map 0:1 -map 0:2 -map 0:3  \\\n");
                    } else if (audio_count == 4) {
                        writer.write("  -map 0:0 -map 0:1 -map 0:2 -map 0:3 -map 0:4  \\\n");
                    } else if (audio_count == 5) {
                        writer.write("  -map 0:0 -map 0:1 -map 0:2 -map 0:3 -map 0:4 -map 0:5  \\\n");
                    } else {
                        writer.write("  -map 0:0 -map 0:1  \\\n");
                    }
                    if (channel_type2.contains("sd")) {
                        writer.write("  -c:a aac -b:a 128k -ar 48000 \\\n");
                    } else {
                        writer.write("  -c:a aac -b:a 256k -ar 48000 \\\n");
                    }
                    writer.write("  -threads 4 -f hls -hls_time 2 -hls_wrap 15 \\\n");
                } else {
                    if (channel_type2.contains("sd")) {
                        writer.write("  -c:a copy -copy_unknown -c:a aac -b:a 128k -ar 48000 \\\n");
                    } else {
                        writer.write("  -c:a copy -copy_unknown -c:a aac -b:a 256k -ar 48000 \\\n");
                    }
                    writer.write(" -map 0:p:" + program_no + " -threads 4 -f hls -hls_time 2 -hls_wrap 15 \\\n");
                }
                writer.write("  \"manifest.m3u8\" \\\n");
                writer.write("</dev/null > /dev/null 2>&1 2>file.txt & echo $! > $STREAM_PID_PATH\n");
                writer.close();
                new LinuxCommandExecutor().givePermission(Presetlocation + "/preset_" + channel_type2);
            }
            catch (Exception e) {
                System.out.println("Exception at Make Script:" + e.getMessage());
            }
        }

        public void roweditstopService(int stream_id) {
            String output = "";
            try {
                String[] commands;
                System.out.println("STREAM ID:" + stream_id);
                for (String c : commands = new String[]{"stream" + stream_id + " stop"}) {
                    Process process = Runtime.getRuntime().exec(c, null, null);
                    BufferedReader in = new BufferedReader(new InputStreamReader(process.getInputStream()));
                    String line = null;
                    while ((line = in.readLine()) != null) {
                        output = output + "\n" + line;
                    }
                }
            }
            catch (Exception e) {
                System.out.println("EXCEPTION:" + e.getMessage());
            }
        }

        public void makeServiceFile(String service_location) {
            try {
                BufferedWriter writer = null;
                writer = new BufferedWriter(new FileWriter(service_location));
                writer.write("#!/bin/sh \n");
                writer.write("\n");
                writer.write("# HLS_STREAM \n");
                writer.write("\n");
                writer.write("get_stream_name=$(basename \"$0\") \n");
                writer.write("\n");
                writer.write("STREAM_NAME=$(echo \"$get_stream_name\") \n");
                writer.write("\n");
                writer.write("PATH_TO_JAR=/home/user/RIDSYSPACKAGE/riptv/live/$STREAM_NAME \n");
                writer.write("STREAM_PID_PATH=/home/user/RIDSYSPACKAGE/pid/$STREAM_NAME-pid \n");
                writer.write("\n");
                writer.write("case $1 in \n");
                writer.write("    start) \n");
                writer.write("        echo \"Starting $STREAM_NAME ...\" \n");
                writer.write("        if [ ! -f $STREAM_PID_PATH ]; then \n");
                writer.write("            cd $PATH_TO_JAR \n");
                writer.write("            nohup ./RStream </dev/null > /dev/null 2>&1 & echo $! > $STREAM_PID_PATH \n");
                writer.write("            echo \"$STREAM_NAME started ...\" \n");
                writer.write("        else \n");
                writer.write("            echo \"$STREAM_NAME is already running ...\" \n");
                writer.write("        fi \n");
                writer.write("    ;; \n");
                writer.write("    stop) \n");
                writer.write("        if [ -f $STREAM_PID_PATH ]; then \n");
                writer.write("            PID=$(cat $STREAM_PID_PATH); \n");
                writer.write("            echo \"$STREAM_NAME stoping ...\" \n");
                writer.write("            kill $PID; \n");
                writer.write("            echo \"$STREAM_NAME stopped ...\" \n");
                writer.write("            rm $STREAM_PID_PATH \n");
                writer.write("        else \n");
                writer.write("            echo \"$STREAM_NAME is not running ...\" \n");
                writer.write("        fi \n");
                writer.write("    ;; \n");
                writer.write("    restart) \n");
                writer.write("        if [ -f $STREAM_PID_PATH ]; then \n");
                writer.write("            PID=$(cat $STREAM_PID_PATH); \n");
                writer.write("            echo \"$STREAM_NAME stopping ...\"; \n");
                writer.write("            kill $PID; \n");
                writer.write("            echo \"$STREAM_NAME stopped ...\"; \n");
                writer.write("            rm $STREAM_PID_PATH \n");
                writer.write("            echo \"$STREAM_NAME starting ...\" \n");
                writer.write("            cd $PATH_TO_JAR \n");
                writer.write("            nohup ./RStream /tmp 2>> /dev/null >> /dev/null & \n");
                writer.write("                        echo $! > $STREAM_PID_PATH \n");
                writer.write("            echo \"$STREAM_NAME started ...\" \n");
                writer.write("        else \n");
                writer.write("            echo \"$STREAM_NAME is not running ...\" \n");
                writer.write("        fi \n");
                writer.write("    ;; esac \n");
                writer.close();
                System.out.println("service location:" + service_location);
                new LinuxCommandExecutor().givePermission(service_location);
            }
            catch (Exception e) {
                System.out.println("Exception at Make Script:" + e.getMessage());
            }
        }

        public boolean isStreamerPIDExist(int streamid) {
            try {
                File f = new File("/home/user/RIDSYSPACKAGE/pid/stream" + streamid + "-pid");
                System.out.println(f.exists());
                return f.exists() && f.isFile();
            }
            catch (Exception e) {
                return false;
            }
        }

        public void roweditRestartStream(int stream_id) {
            String output = "";
            try {
                String[] commands;
                System.out.println("STREAM ID:" + stream_id);
                for (String c : commands = new String[]{"stream" + stream_id + " stop", "stream" + stream_id + " start"}) {
                    Process process = Runtime.getRuntime().exec(c, null, null);
                    BufferedReader in = new BufferedReader(new InputStreamReader(process.getInputStream()));
                    String line = null;
                    while ((line = in.readLine()) != null) {
                        output = output + "\n" + line;
                    }
                }
            }
            catch (Exception e) {
                System.out.println("EXCEPTION:" + e.getMessage());
            }
        }

        private String sendCommand(String server_ip, String json) {
            String responce = "";
            try {
                Socket socket = null;
                Object writer = null;
                try {
                    socket = new Socket(server_ip, 3000);
                    System.out.println("CAS Adapter request" + server_ip);
                    PrintWriter toServer = new PrintWriter(socket.getOutputStream(), true);
                    BufferedReader fromServer = new BufferedReader(new InputStreamReader(socket.getInputStream()));
                    toServer.println(json);
                    socket.setSoTimeout(15000);
                    responce = fromServer.readLine();
                    System.out.println("Client received: " + responce + " from Server");
                    toServer.close();
                    fromServer.close();
                }
                catch (Exception e) {
                    responce = e.getMessage();
                    System.out.println("Exception:" + e.getMessage());
                }
            }
            catch (Exception e) {
                System.out.println("send command:" + e.getMessage());
            }
            return responce;
        }
    }

    static class getStream
    implements HttpHandler {
        private channels cha_obj;
        private int id;

        getStream() {
        }

        public channels getCha_obj() {
            return this.cha_obj;
        }

        public void setCha_obj(channels cha_obj) {
            this.cha_obj = cha_obj;
        }

        public int getId() {
            return this.id;
        }

        public void setId(int id) {
            this.id = id;
        }

        @Override
        public void handle(HttpExchange t) throws IOException {
            String line;
            String accessip = "";
            System.out.println("enter into stream create..");
            InputStream intp = t.getRequestBody();
            BufferedReader br = new BufferedReader(new InputStreamReader(intp));
            StringBuilder builder = new StringBuilder();
            String data = "";
            while ((line = br.readLine()) != null) {
                builder.append(line);
            }
            data = builder.toString();
            Object obj = null;
            JSONObject json_data = null;
            try {
                JSONParser parser = new JSONParser();
                obj = parser.parse(data);
                json_data = (JSONObject)obj;
            }
            catch (Exception parser) {
                // empty catch block
            }
            System.out.println("json" + json_data);
            this.cha_obj = new channels();
            try {
                this.cha_obj.setUdp_url(json_data.get((Object)"udpurl").toString());
                this.cha_obj.setUrl(json_data.get((Object)"url").toString());
                if (json_data.get((Object)"inputip") == null || json_data.get((Object)"inputip").toString().equals("")) {
                    this.cha_obj.setInputip("");
                } else {
                    this.cha_obj.setInputip(json_data.get((Object)"inputip").toString());
                }
                if (json_data.get((Object)"outputip") == null || json_data.get((Object)"outputip").toString().equals("")) {
                    this.cha_obj.setOutputip("");
                } else {
                    this.cha_obj.setOutputip(json_data.get((Object)"outputip").toString());
                }
                this.cha_obj.setProgram_no(Integer.parseInt(json_data.get((Object)"program_number").toString()));
                this.cha_obj.setChannel_name(json_data.get((Object)"channelname").toString());
                if (json_data.get((Object)"oldchannelname") == null || json_data.get((Object)"oldchannelname").toString().equals("")) {
                    this.cha_obj.setInput_channel_name(json_data.get((Object)"channelname").toString());
                } else {
                    this.cha_obj.setInput_channel_name(json_data.get((Object)"oldchannelname").toString());
                }
                this.cha_obj.setStream_location(json_data.get((Object)"stream_location").toString());
                this.cha_obj.setMax_id(Integer.parseInt(json_data.get((Object)"max_id").toString()));
                this.cha_obj.setIsMPTS(Boolean.parseBoolean(json_data.get((Object)"isMPTS").toString()));
                this.cha_obj.setIs_drm(Boolean.parseBoolean(json_data.get((Object)"isdrm").toString()));
                this.cha_obj.setService_location(json_data.get((Object)"service_location").toString());
                this.cha_obj.setStreamtype(json_data.get((Object)"Streamtype").toString());
                this.cha_obj.setClienttype(json_data.get((Object)"clienttype").toString());
            }
            catch (Exception e) {
                System.out.println("Exception :" + e);
            }
            String response = this.create(accessip);
            System.out.println("response" + response);
            t.sendResponseHeaders(200, response.getBytes().length);
            OutputStream os = t.getResponseBody();
            os.write(response.getBytes());
            os.close();
        }

        public String create(String accessip) {
            String responce = "";
            try {
                if (!this.cha_obj.getStreamtype().equals("url")) {
                    new LinuxCommandExecutor().makeDirectory("/home/user/RIDSYSPACKAGE/riptv/live/stream" + (this.cha_obj.getMax_id() + 1));
                    StringBuilder inurl = new StringBuilder(this.cha_obj.getUdp_url());
                    StringBuilder outurl = new StringBuilder(this.cha_obj.getUrl());
                    if (this.cha_obj.getStreamtype().equals("preset_udp_drm") || this.cha_obj.getStreamtype().equals("preset_udp") || this.cha_obj.getStreamtype().equals("preset_mpts_udp_drm") || this.cha_obj.getStreamtype().equals("preset_mpts_udp")) {
                        inurl = new StringBuilder(this.cha_obj.getUdp_url().substring(6, this.cha_obj.getUdp_url().length()));
                        outurl = new StringBuilder(this.cha_obj.getUrl().substring(6, this.cha_obj.getUrl().length()));
                    } else if (this.cha_obj.getStreamtype().equals("preset_hls_to_udp") || this.cha_obj.getStreamtype().equals("preset_hls_to_udp_drm")) {
                        outurl = new StringBuilder(this.cha_obj.getUrl().substring(6, this.cha_obj.getUrl().length()));
                    } else if (this.cha_obj.getStreamtype().equals("preset_hls") || this.cha_obj.getStreamtype().equals("preset_hls_drm")) {
                        inurl = new StringBuilder(this.cha_obj.getUdp_url().substring(6, this.cha_obj.getUdp_url().length()));
                    }
                    if (this.cha_obj.getClienttype() != null && !this.cha_obj.getClienttype().equals("")) {
                        new LinuxCommandExecutor().makeDirectory(this.cha_obj.getStream_location() + "/stream" + (this.cha_obj.getMax_id() + 1));
                        if (this.cha_obj.getClienttype().equalsIgnoreCase("file")) {
                            IPTVListener.Rstream(this.cha_obj.getStream_location() + "/stream" + (this.cha_obj.getMax_id() + 1), this.cha_obj.getMax_id() + 1, inurl.toString(), outurl.toString(), this.cha_obj.getInputip(), this.cha_obj.getOutputip(), this.cha_obj.getChannel_name(), this.cha_obj.getProgram_no(), this.cha_obj.isIsMPTS(), this.cha_obj.getInput_channel_name(), this.cha_obj.getStreamtype());
                            IPTVListener.makeAutoscriptfileForUDP1(this.cha_obj.getService_location() + "stream" + (this.cha_obj.getMax_id() + 1));
                        } else if (this.cha_obj.getClienttype().equalsIgnoreCase("ffprobe")) {
                            if (this.cha_obj.isIs_drm()) {
                                new LinuxCommandExecutor().makeDirectory(this.cha_obj.getStream_location() + "/stream" + (this.cha_obj.getMax_id() + 1) + "/playlist");
                                FfprobeStreamFiles.Rstream_drm(this.cha_obj.getStream_location() + "/stream" + (this.cha_obj.getMax_id() + 1), "stream" + (this.cha_obj.getMax_id() + 1), inurl.toString(), this.cha_obj.getChannel_name(), this.cha_obj.getInputip(), this.cha_obj.getInput_channel_name());
                                FfprobeStreamFiles.Preset_drm(this.cha_obj.getStream_location() + "/stream" + (this.cha_obj.getMax_id() + 1));
                                FfprobeStreamFiles.KeyGenerator(this.cha_obj.getStream_location() + "/stream" + (this.cha_obj.getMax_id() + 1));
                                FfprobeStreamFiles.makeServiceDRMFile(this.cha_obj.getService_location() + "stream" + (this.cha_obj.getMax_id() + 1));
                            } else {
                                FfprobeStreamFiles.Rstream(this.cha_obj.getStream_location() + "/stream" + (this.cha_obj.getMax_id() + 1), "stream" + (this.cha_obj.getMax_id() + 1), inurl.toString(), this.cha_obj.getChannel_name(), this.cha_obj.getInputip(), this.cha_obj.getInput_channel_name());
                                FfprobeStreamFiles.Preset(this.cha_obj.getStream_location() + "/stream" + (this.cha_obj.getMax_id() + 1));
                                IPTVListener.makeAutoscriptfileForUDP1(this.cha_obj.getService_location() + "stream" + (this.cha_obj.getMax_id() + 1));
                            }
                        }
                    }
                    new LinuxCommandExecutor().moveServiceFile(this.cha_obj.getMax_id() + 1);
                    new LinuxCommandExecutor().removeFile(this.cha_obj.getService_location() + "stream" + (this.cha_obj.getMax_id() + 1));
                    this.start(this.cha_obj.getMax_id() + 1);
                    IPTVListener.fileWriter("stream" + (this.cha_obj.getMax_id() + 1));
                }
                responce = "Succesful Stream" + this.cha_obj.getChannel_name() + " is Created.";
            }
            catch (Exception e) {
                System.out.println("Exception e:" + e.getMessage());
            }
            return responce;
        }

        public void autoScript(String location) {
            try {
                BufferedWriter writer = null;
                writer = new BufferedWriter(new FileWriter(location));
                writer.write("#!/bin/sh \n\n");
                writer.write("get_stream_name=$(basename \"$0\")   \n\n");
                writer.write("STREAM_NAME=$(echo \"$get_stream_name\")   \n\n");
                writer.write("PATH_TO_JAR=/home/user/RIDSYSPACKAGE/riptv/live/$STREAM_NAME  \n");
                writer.write("STREAM_PID_PATH=/home/user/RIDSYSPACKAGE/pid/$STREAM_NAME-pid   \n\n");
                writer.write("case $1 in   \n");
                writer.write("    start)   \n");
                writer.write("        echo \"Starting $STREAM_NAME ...\"  \n");
                writer.write("        if [ ! -f $STREAM_PID_PATH ]; then  \n");
                writer.write("            cd $PATH_TO_JAR  \n");
                writer.write("            nohup ./RStream </dev/null > /dev/null 2>&1 & echo $! > $STREAM_PID_PATH \n");
                writer.write("            echo \"$STREAM_NAME started ...\"  \n");
                writer.write("        else  \n");
                writer.write("            echo \"$STREAM_NAME is already running ...\"  \n");
                writer.write("        fi  \n");
                writer.write("    ;;  \n");
                writer.write("    stop) \n");
                writer.write("        if [ -f $STREAM_PID_PATH ]; then  \n");
                writer.write("            PID=$(cat $STREAM_PID_PATH);  \n");
                writer.write("            echo \"$STREAM_NAME stoping ...\"  \n");
                writer.write("            kill $PID;  \n");
                writer.write("            echo \"$STREAM_NAME stopped ...\"  \n");
                writer.write("            rm $STREAM_PID_PATH \n");
                writer.write("         else  \n");
                writer.write("            echo \"$STREAM_NAME is not running ...\"  \n");
                writer.write("        fi  \n");
                writer.write("     ;; \n");
                writer.write("     restart)  \n");
                writer.write("        if [ -f $STREAM_PID_PATH ]; then  \n");
                writer.write("            PID=$(cat $STREAM_PID_PATH);  \n");
                writer.write("            echo \"$STREAM_NAME stopping ...\";  \n");
                writer.write("            kill $PID; \n");
                writer.write("            echo \"$STREAM_NAME stopped ...\"; \n");
                writer.write("            rm $STREAM_PID_PATH  \n");
                writer.write("            echo \"$STREAM_NAME starting ...\" \n");
                writer.write("            cd $PATH_TO_JAR  \n");
                writer.write("            nohup ./RStream /tmp 2>> /dev/null >> /dev/null & \n");
                writer.write("                        echo $! > $STREAM_PID_PATH \n");
                writer.write("            echo \"$STREAM_NAME started ...\" \n");
                writer.write("        else \n");
                writer.write("            echo \"$STREAM_NAME is not running ...\"  \n");
                writer.write("        fi  \n");
                writer.write("     ;; esac  \n");
                writer.close();
                new LinuxCommandExecutor().givePermission(location);
            }
            catch (Exception e) {
                System.out.println("Exception at Make AutoScript:" + e.getMessage());
            }
        }

        public String start(int stream_id) {
            String output = "";
            try {
                String[] commands;
                System.out.println("STREAM ID:" + stream_id);
                for (String c : commands = new String[]{"stream" + stream_id + " start"}) {
                    Process process = Runtime.getRuntime().exec(c, null, null);
                    BufferedReader in = new BufferedReader(new InputStreamReader(process.getInputStream()));
                    String line = null;
                    while ((line = in.readLine()) != null) {
                        output = output + "\n" + line;
                    }
                    Thread.sleep(2000L);
                }
                output = "Success:" + output;
            }
            catch (Exception e) {
                System.out.println("Exception at playout function:" + e.getMessage());
                output = output + e.getMessage();
                output = "Failed:" + output;
            }
            return output;
        }
    }

    static class getInter
    implements HttpHandler {
        getInter() {
        }

        @Override
        public void handle(HttpExchange t) throws IOException {
            System.out.println("client connected..");
            getInter sp = new getInter();
            String response = sp.getInterface();
            t.sendResponseHeaders(200, response.getBytes().length);
            OutputStream os = t.getResponseBody();
            os.write(response.getBytes());
            os.close();
        }

        public String getInterface() {
            System.out.println("get interface----------------------------------------------------------------");
            ArrayList<String> output = new ArrayList<String>();
            String jsontext = null;
            try {
                String line;
                ProcessBuilder processBuilder = new ProcessBuilder(new String[0]);
                processBuilder.command("bash", "-c", "ifconfig  | sed 's/[ :\t].*//;/^\\(lo\\|\\)$/d'");
                Process process = processBuilder.start();
                BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
                while ((line = reader.readLine()) != null) {
                    output.add(line);
                }
                ArrayList lst = new ArrayList();
                for (String inter_obj : output) {
                    HashMap<String, String> map = new HashMap<String, String>();
                    map.put("interface_name", inter_obj);
                    map.put("interface_ip", getInter.getInterfaceIp(inter_obj));
                    lst.add(map);
                }
                jsontext = JSONValue.toJSONString(lst);
                System.out.println(jsontext);
            }
            catch (IOException e) {
                System.out.println("Exception at :" + e.getMessage());
            }
            return jsontext;
        }

        public static String getInterfaceIp(String inter_name) {
            String output = null;
            try {
                String line;
                ProcessBuilder processBuilder = new ProcessBuilder(new String[0]);
                processBuilder.command("bash", "-c", "ip addr show " + inter_name + " | grep \"inet\\b\" | awk '{print $2}' | cut -d/ -f1");
                Process process = processBuilder.start();
                BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
                while ((line = reader.readLine()) != null) {
                    output = line;
                }
            }
            catch (Exception e) {
                System.out.println("Exception at trackextractor:" + e.getMessage());
            }
            return output;
        }
    }

    static class MyGet
    implements HttpHandler {
        MyGet() {
        }

        @Override
        public void handle(HttpExchange t) throws IOException {
            System.out.println("client connected..");
            System.out.println("Stream extracter----------------------------------------------------------------");
            InputStream intp = t.getRequestBody();
            BufferedReader br = new BufferedReader(new InputStreamReader(intp));
            String s = br.readLine();
            System.out.println("result=" + s);
            MyGet sp = new MyGet();
            String response = sp.getStreamExtractor(s);
            t.sendResponseHeaders(200, response.getBytes().length);
            OutputStream os = t.getResponseBody();
            os.write(response.getBytes());
            os.close();
        }

        public String getStreamExtractor(String udp) {
            System.out.println("udp:" + udp);
            String json = "";
            String out = "Success";
            try {
                ProcessBuilder processBuilder = new ProcessBuilder(new String[0]);
                processBuilder.command("bash", "-c", "timeout 15s ffprobe -v quiet -print_format json -show_programs " + udp);
                Process process = processBuilder.start();
                BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
                String json_string = "";
                String line = null;
                while ((line = reader.readLine()) != null) {
                    json_string = json_string + line;
                    boolean status = true;
                }
                JSONParser parser = new JSONParser();
                Object obj = parser.parse(json_string);
                JSONObject json_data = (JSONObject)obj;
                json = json_data.toString();
                System.out.println("data" + json);
            }
            catch (Exception e) {
                System.out.println("Exception at trackextractor:" + e.getMessage());
                out = "Stream not receving";
                boolean bl = false;
            }
            return json;
        }
    }

    static class conStream
    implements HttpHandler {
        private channels cha_obj;
        private List<channels> channellist;
        private String response;
        String filepath = "/home/user/RIDSYSPACKAGE/riptv/live/";
        String servicefile_path = "/usr/local/bin/";

        conStream() {
        }

        public String getResponse() {
            return this.response;
        }

        public void setResponse(String response) {
            this.response = response;
        }

        public channels getCha_obj() {
            return this.cha_obj;
        }

        public void setCha_obj(channels cha_obj) {
            this.cha_obj = cha_obj;
        }

        public List<channels> getChannellist() {
            return this.channellist;
        }

        public void setChannellist(List<channels> channellist) {
            this.channellist = channellist;
        }

        @Override
        public void handle(HttpExchange t) throws IOException {
            String line;
            System.out.println("Stream controll----------------------------------------------------------------");
            this.cha_obj = new channels();
            InputStream intp = t.getRequestBody();
            BufferedReader br = new BufferedReader(new InputStreamReader(intp));
            StringBuilder builder = new StringBuilder();
            String data = "";
            while ((line = br.readLine()) != null) {
                builder.append(line);
            }
            data = builder.toString();
            Object obj = null;
            JSONObject json_data = null;
            try {
                JSONParser parser = new JSONParser();
                obj = parser.parse(data);
                json_data = (JSONObject)obj;
            }
            catch (Exception parser) {
                // empty catch block
            }
            System.out.println("json" + json_data);
            this.cha_obj.setAction(json_data.get((Object)"action").toString());
            this.cha_obj.setUdp_url(json_data.get((Object)"udpurl").toString());
            this.cha_obj.setProgram_no(Integer.parseInt(json_data.get((Object)"program_number").toString()));
            this.cha_obj.setChannel_name(json_data.get((Object)"channelname").toString());
            if (json_data.get((Object)"oldchannelname") == null || json_data.get((Object)"oldchannelname").toString().equals("")) {
                this.cha_obj.setInput_channel_name(json_data.get((Object)"channelname").toString());
            } else {
                this.cha_obj.setInput_channel_name(json_data.get((Object)"oldchannelname").toString());
            }
            this.cha_obj.setStream_location(json_data.get((Object)"stream_location").toString());
            this.cha_obj.setId(Integer.parseInt(json_data.get((Object)"id").toString()));
            this.cha_obj.setIsMPTS(Boolean.parseBoolean(json_data.get((Object)"isMPTS").toString()));
            this.cha_obj.setIs_drm(Boolean.parseBoolean(json_data.get((Object)"isdrm").toString()));
            this.cha_obj.setClienttype(json_data.get((Object)"clienttype").toString());
            this.cha_obj.setService_location(json_data.get((Object)"service_location").toString());
            this.cha_obj.setUrl(json_data.get((Object)"url").toString());
            if (json_data.get((Object)"inputip") == null || json_data.get((Object)"inputip").toString().equals("")) {
                this.cha_obj.setInputip("");
            } else {
                this.cha_obj.setInputip(json_data.get((Object)"inputip").toString());
            }
            if (json_data.get((Object)"outputip") == null || json_data.get((Object)"outputip").toString().equals("")) {
                this.cha_obj.setOutputip("");
            } else {
                this.cha_obj.setOutputip(json_data.get((Object)"outputip").toString());
            }
            this.cha_obj.setStreamtype(json_data.get((Object)"Streamtype").toString());
            this.cha_obj.setStatus(Boolean.parseBoolean(json_data.get((Object)"status").toString()));
            if (this.cha_obj.getAction().equals("Start")) {
                this.response = this.start(this.cha_obj.getId());
            } else if (this.cha_obj.getAction().equals("Stop")) {
                this.response = this.stopService(this.cha_obj.getId());
            } else if (this.cha_obj.getAction().equals("Restart")) {
                this.response = this.restart(this.cha_obj.getId());
            }
            System.out.println("response is=" + this.response);
            System.out.println("length" + this.response.getBytes().length);
            System.out.println("bytes" + this.response.getBytes());
            t.sendResponseHeaders(200, this.response.getBytes().length);
            OutputStream os = t.getResponseBody();
            os.write(this.response.getBytes());
            os.close();
        }

        public String start(int stream_id) {
            String outputt = "";
            try {
                String[] commands;
                System.out.println("STREAM ID:" + stream_id);
                System.out.println(this.filepath);
                this.streamcheak(stream_id);
                for (String c : commands = new String[]{"stream" + stream_id + " start"}) {
                    Process process = Runtime.getRuntime().exec(c, null, null);
                    BufferedReader in = new BufferedReader(new InputStreamReader(process.getInputStream()));
                    String line = null;
                    while ((line = in.readLine()) != null) {
                        String output = "";
                        output = output + "\n" + line;
                        System.out.println("stream start" + line);
                    }
                    Thread.sleep(2000L);
                }
                outputt = "Successfully started";
                IPTVListener.fileWriter("stream" + stream_id);
            }
            catch (Exception e) {
                System.out.println("Exception at stream start:" + e.getMessage());
                outputt = "failed";
            }
            return outputt;
        }

        public String stopService(int stream_id) {
            String outputt = "";
            try {
                String[] commands;
                System.out.println("STREAM ID:" + stream_id);
                for (String c : commands = new String[]{"stream" + stream_id + " stop"}) {
                    Process process = Runtime.getRuntime().exec(c, null, null);
                    BufferedReader in = new BufferedReader(new InputStreamReader(process.getInputStream()));
                    String line = null;
                    while ((line = in.readLine()) != null) {
                        String output = "";
                        output = output + "\n" + line;
                    }
                    Thread.sleep(2000L);
                }
                outputt = "Successfully stopped";
                IPTVListener.fileWriterRemove("stream" + stream_id);
            }
            catch (Exception e) {
                System.out.println("Exception at stop function:" + e.getMessage());
                outputt = "failed";
            }
            return outputt;
        }

        public String restart(int stream_id) {
            String outputt = "";
            try {
                System.out.println("STREAM ID:" + stream_id);
                String[] commands = new String[]{"stream" + stream_id + " stop", "stream" + stream_id + " start"};
                this.streamcheak(stream_id);
                for (String c : commands) {
                    Process process = Runtime.getRuntime().exec(c, null, null);
                    BufferedReader in = new BufferedReader(new InputStreamReader(process.getInputStream()));
                    String line = null;
                    while ((line = in.readLine()) != null) {
                        String output = "";
                        output = output + "\n" + line;
                    }
                    Thread.sleep(2000L);
                }
                outputt = "Successully restarted";
            }
            catch (Exception e) {
                System.out.println("Exception at playout function:" + e.getMessage());
                outputt = "failed";
            }
            return outputt;
        }

        private void streamcheak(int stream_id) {
            if (new LinuxCommandExecutor().getfile(this.filepath + "stream" + stream_id)) {
                System.out.println("main file available");
                if (!new LinuxCommandExecutor().getfile(this.servicefile_path + "stream" + stream_id)) {
                    if (this.cha_obj.getClienttype().equalsIgnoreCase("file")) {
                        IPTVListener.makeAutoscriptfileForUDP1(this.cha_obj.getService_location() + "stream" + stream_id);
                    } else if (this.cha_obj.getClienttype().equalsIgnoreCase("ffprobe")) {
                        if (this.cha_obj.isIs_drm()) {
                            FfprobeStreamFiles.makeServiceDRMFile(this.cha_obj.getService_location() + "stream" + stream_id);
                        } else {
                            IPTVListener.makeAutoscriptfileForUDP1(this.cha_obj.getService_location() + "stream" + stream_id);
                        }
                    }
                    new LinuxCommandExecutor().moveServiceFile(stream_id);
                    new LinuxCommandExecutor().removeFile(this.cha_obj.getService_location() + "stream" + stream_id);
                }
            } else {
                System.out.println("main file not available");
                try {
                    if (!this.cha_obj.getStreamtype().equals("url")) {
                        StringBuilder inurl = new StringBuilder(this.cha_obj.getUdp_url());
                        StringBuilder outurl = new StringBuilder(this.cha_obj.getUrl());
                        if (this.cha_obj.getStreamtype().equals("preset_udp_drm") || this.cha_obj.getStreamtype().equals("preset_udp") || this.cha_obj.getStreamtype().equals("preset_mpts_udp_drm") || this.cha_obj.getStreamtype().equals("preset_mpts_udp")) {
                            inurl = new StringBuilder(this.cha_obj.getUdp_url().substring(6, this.cha_obj.getUdp_url().length()));
                            outurl = new StringBuilder(this.cha_obj.getUrl().substring(6, this.cha_obj.getUrl().length()));
                        } else if (this.cha_obj.getStreamtype().equals("preset_hls_to_udp") || this.cha_obj.getStreamtype().equals("preset_hls_to_udp_drm")) {
                            outurl = new StringBuilder(this.cha_obj.getUrl().substring(6, this.cha_obj.getUrl().length()));
                        } else if (this.cha_obj.getStreamtype().equals("preset_hls") || this.cha_obj.getStreamtype().equals("preset_hls_drm")) {
                            inurl = new StringBuilder(this.cha_obj.getUdp_url().substring(6, this.cha_obj.getUdp_url().length()));
                        }
                        if (this.cha_obj.getClienttype() != null && !this.cha_obj.getClienttype().equals("")) {
                            new LinuxCommandExecutor().makeDirectory(this.cha_obj.getStream_location() + "stream" + stream_id);
                            if (this.cha_obj.getClienttype().equalsIgnoreCase("file")) {
                                IPTVListener.Rstream(this.cha_obj.getStream_location() + "/stream" + stream_id, stream_id, inurl.toString(), outurl.toString(), this.cha_obj.getInputip(), this.cha_obj.getOutputip(), this.cha_obj.getChannel_name(), this.cha_obj.getProgram_no(), this.cha_obj.isIsMPTS(), this.cha_obj.getInput_channel_name(), this.cha_obj.getStreamtype());
                                IPTVListener.makeAutoscriptfileForUDP1(this.cha_obj.getService_location() + "stream" + stream_id);
                            } else if (this.cha_obj.getClienttype().equalsIgnoreCase("ffprobe")) {
                                if (this.cha_obj.isIs_drm()) {
                                    new LinuxCommandExecutor().makeDirectory(this.cha_obj.getStream_location() + "/stream" + stream_id + "/playlist");
                                    FfprobeStreamFiles.Rstream_drm(this.cha_obj.getStream_location() + "/stream" + stream_id, "stream" + stream_id, inurl.toString(), this.cha_obj.getChannel_name(), this.cha_obj.getInputip(), this.cha_obj.getInput_channel_name());
                                    FfprobeStreamFiles.Preset_drm(this.cha_obj.getStream_location() + "/stream" + stream_id);
                                    FfprobeStreamFiles.KeyGenerator(this.cha_obj.getStream_location() + "/stream" + stream_id);
                                    FfprobeStreamFiles.makeServiceDRMFile(this.cha_obj.getService_location() + "stream" + stream_id);
                                } else {
                                    FfprobeStreamFiles.Rstream(this.cha_obj.getStream_location() + "/stream" + stream_id, "stream" + stream_id, inurl.toString(), this.cha_obj.getChannel_name(), this.cha_obj.getInputip(), this.cha_obj.getInput_channel_name());
                                    FfprobeStreamFiles.Preset(this.cha_obj.getStream_location() + "/stream" + stream_id);
                                    IPTVListener.makeAutoscriptfileForUDP1(this.cha_obj.getService_location() + "stream" + stream_id);
                                }
                            }
                        }
                        new LinuxCommandExecutor().moveServiceFile(stream_id);
                        new LinuxCommandExecutor().removeFile(this.cha_obj.getService_location() + "stream" + stream_id);
                        this.restart(stream_id);
                        IPTVListener.fileWriter("stream" + stream_id);
                    }
                }
                catch (Exception e) {
                    System.out.println("Exception e:" + e.getMessage());
                }
            }
        }
    }

    static class conInputService
    implements HttpHandler {
        private server_detail ser_obj;
        private String response;

        conInputService() {
        }

        @Override
        public void handle(HttpExchange t) throws IOException {
            String line;
            this.ser_obj = new server_detail();
            System.out.println("client connected..");
            InputStream intp = t.getRequestBody();
            BufferedReader br = new BufferedReader(new InputStreamReader(intp));
            StringBuilder builder = new StringBuilder();
            String data = "";
            while ((line = br.readLine()) != null) {
                builder.append(line);
            }
            data = builder.toString();
            Object obj = null;
            JSONObject json_data = null;
            try {
                JSONParser parser = new JSONParser();
                obj = parser.parse(data);
                json_data = (JSONObject)obj;
            }
            catch (Exception parser) {
                // empty catch block
            }
            System.out.println("json" + json_data);
            this.ser_obj.setService_name(json_data.get((Object)"service_name").toString());
            this.ser_obj.setAction(json_data.get((Object)"action").toString());
            this.response = this.Service(this.ser_obj.getService_name(), this.ser_obj.getAction());
            System.out.println("response is=" + this.response);
            t.sendResponseHeaders(200, this.response.getBytes().length);
            OutputStream os = t.getResponseBody();
            os.write(this.response.getBytes());
            os.close();
        }

        public String Service(String service_name, String action) {
            int count = 0;
            String output = "";
            System.out.println("input service----------------------------------------------------------------");
            try {
                String[] commands;
                for (String c : commands = new String[]{service_name + " " + action}) {
                    int i = 0;
                    System.out.println(c);
                    Process process = Runtime.getRuntime().exec(c, null, null);
                    BufferedReader in = new BufferedReader(new InputStreamReader(process.getInputStream()));
                    String line = null;
                    int countt = 0;
                    while ((line = in.readLine()) != null) {
                        output = output + "\n" + line;
                        ++countt;
                    }
                    System.out.println("while loop count" + countt);
                    Thread.sleep(2000L);
                    System.out.println("for loop count" + ++i);
                }
                System.out.println("output is" + output);
            }
            catch (Exception e) {
                System.out.println("Exception at start function:" + e.getMessage());
                output = output + e.getMessage();
            }
            System.out.println("method count" + ++count);
            return output;
        }
    }

    static class conRstream
    implements HttpHandler {
        private server_detail ser_obj;
        private String response;

        conRstream() {
        }

        @Override
        public void handle(HttpExchange t) throws IOException {
            String line;
            this.ser_obj = new server_detail();
            System.out.println("client connected..");
            InputStream intp = t.getRequestBody();
            BufferedReader br = new BufferedReader(new InputStreamReader(intp));
            StringBuilder builder = new StringBuilder();
            String data = "";
            while ((line = br.readLine()) != null) {
                builder.append(line);
            }
            data = builder.toString();
            Object obj = null;
            JSONObject json_data = null;
            try {
                JSONParser parser = new JSONParser();
                obj = parser.parse(data);
                json_data = (JSONObject)obj;
            }
            catch (Exception parser) {
                // empty catch block
            }
            System.out.println("json" + json_data);
            this.ser_obj.setService_name(json_data.get((Object)"service_name").toString());
            this.ser_obj.setAction(json_data.get((Object)"action").toString());
            if (this.ser_obj.getAction().equals("Start")) {
                this.response = this.start(this.ser_obj.getService_name());
            } else if (this.ser_obj.getAction().equals("Stop")) {
                this.response = this.stop(this.ser_obj.getService_name());
            } else if (this.ser_obj.getAction().equals("Restart")) {
                this.response = this.restart(this.ser_obj.getService_name());
            }
            System.out.println("response is=" + this.response);
            t.sendResponseHeaders(200, this.response.getBytes().length);
            OutputStream os = t.getResponseBody();
            os.write(this.response.getBytes());
            os.close();
        }

        public String start(String service_name) {
            System.out.println("RStream controll----------------------------------------------------------------");
            int count = 0;
            String output = "";
            try {
                String[] commands;
                for (String c : commands = new String[]{service_name + " start"}) {
                    int i = 0;
                    Process process = Runtime.getRuntime().exec(c, null, null);
                    BufferedReader in = new BufferedReader(new InputStreamReader(process.getInputStream()));
                    String line = null;
                    int countt = 0;
                    while ((line = in.readLine()) != null) {
                        output = output + "\n" + line;
                        ++countt;
                    }
                    System.out.println("while loop count" + countt);
                    Thread.sleep(2000L);
                    System.out.println("for loop count" + ++i);
                }
                System.out.println("output is" + output);
            }
            catch (Exception e) {
                System.out.println("Exception at start function:" + e.getMessage());
                output = output + e.getMessage();
            }
            System.out.println("method count" + ++count);
            return output;
        }

        public String stop(String service_name) {
            String output = "";
            try {
                String[] commands;
                for (String c : commands = new String[]{service_name + " stop"}) {
                    Process process = Runtime.getRuntime().exec(c, null, null);
                    BufferedReader in = new BufferedReader(new InputStreamReader(process.getInputStream()));
                    String line = null;
                    while ((line = in.readLine()) != null) {
                        output = output + "\n" + line;
                    }
                    Thread.sleep(2000L);
                }
                System.out.println("output is" + output);
            }
            catch (Exception e) {
                System.out.println("Exception at stop function:" + e.getMessage());
                output = output + e.getMessage();
            }
            return output;
        }

        public String restart(String service_name) {
            String output = "";
            try {
                String[] commands;
                for (String c : commands = new String[]{service_name + " stop", service_name + " start"}) {
                    Process process = Runtime.getRuntime().exec(c, null, null);
                    BufferedReader in = new BufferedReader(new InputStreamReader(process.getInputStream()));
                    String line = null;
                    while ((line = in.readLine()) != null) {
                        output = output + "\n" + line;
                    }
                    Thread.sleep(2000L);
                }
                System.out.println("output is" + output);
            }
            catch (Exception e) {
                System.out.println("Exception at restart function:" + e.getMessage());
                output = output + e.getMessage();
            }
            return output;
        }
    }

    static class deleteStream
    implements HttpHandler {
        private List<Integer> stream_list = new ArrayList<Integer>();
        private int id;

        deleteStream() {
        }

        public List<Integer> getStream_list() {
            return this.stream_list;
        }

        public void setStream_list(List<Integer> stream_list) {
            this.stream_list = stream_list;
        }

        public int getId() {
            return this.id;
        }

        public void setId(int id) {
            this.id = id;
        }

        @Override
        public void handle(HttpExchange t) throws IOException {
            String line;
            System.out.println("client connected..StreamExtracter");
            System.out.println("Stream delete----------------------------------------------------------------");
            InputStream intp = t.getRequestBody();
            BufferedReader br = new BufferedReader(new InputStreamReader(intp));
            StringBuilder builder = new StringBuilder();
            String data = "";
            while ((line = br.readLine()) != null) {
                builder.append(line);
            }
            data = builder.toString();
            Object obj = null;
            JSONObject json_data = null;
            try {
                JSONParser parser = new JSONParser();
                obj = parser.parse(data);
                json_data = (JSONObject)obj;
            }
            catch (Exception parser) {
                // empty catch block
            }
            System.out.println("json" + json_data);
            this.setId(Integer.parseInt(json_data.get((Object)"id").toString()));
            this.setStream_list((List)json_data.get((Object)"stream_list"));
            deleteStream ds = new deleteStream();
            String response = ds.delete(this.id, this.stream_list);
            t.sendResponseHeaders(200, response.getBytes().length);
            OutputStream os = t.getResponseBody();
            os.write(response.getBytes());
            os.close();
        }

        public String delete(int id, List stream_list) {
            this.stopService(id);
            new LinuxCommandExecutor().removeUsrBinLocalFile("/usr/local/bin/stream" + id);
            new LinuxCommandExecutor().removeFolder("/home/user/RIDSYSPACKAGE/riptv/live/stream" + id + "/");
            this.fileWriterRemove(stream_list);
            return "Success";
        }

        public String stopService(int stream_id) {
            String output = "";
            try {
                String[] commands;
                System.out.println("STREAM ID:" + stream_id);
                for (String c : commands = new String[]{"stream" + stream_id + " stop"}) {
                    Process process = Runtime.getRuntime().exec(c, null, null);
                    BufferedReader in = new BufferedReader(new InputStreamReader(process.getInputStream()));
                    String line = null;
                    while ((line = in.readLine()) != null) {
                        output = output + "\n" + line;
                    }
                    Thread.sleep(2000L);
                }
            }
            catch (Exception e) {
                System.out.println("Exception at stop function:" + e.getMessage());
                output = output + e.getMessage();
            }
            return output;
        }

        public String removeUsrBinLocalFile(String file) {
            String result = "";
            try {
                System.out.println("file:" + file);
                String[] commands = new String[]{"sudo rm " + file};
                String output = "";
                for (String c : commands) {
                    Process process = Runtime.getRuntime().exec(c, null, null);
                    BufferedReader in = new BufferedReader(new InputStreamReader(process.getInputStream()));
                    String line = null;
                    while ((line = in.readLine()) != null) {
                        output = output + "\n" + line;
                    }
                }
                result = result + output;
                System.out.println("Success:" + result);
            }
            catch (Exception e) {
                System.out.println(e.getMessage());
            }
            return result;
        }

        public String removeFolder(String folder) {
            String result = "";
            try {
                System.out.println("file:" + folder);
                String[] commands = new String[]{"rm -r " + folder};
                String output = "";
                for (String c : commands) {
                    Process process = Runtime.getRuntime().exec(c, null, null);
                    BufferedReader in = new BufferedReader(new InputStreamReader(process.getInputStream()));
                    String line = null;
                    while ((line = in.readLine()) != null) {
                        output = output + "\n" + line;
                    }
                }
                result = result + output;
                System.out.println("Success:" + result);
            }
            catch (Exception e) {
                System.out.println(e.getMessage());
            }
            return result;
        }

        public void fileWriterRemove(List stream_list) {
            try {
                BufferedWriter writer = null;
                writer = new BufferedWriter(new FileWriter("/home/user/Active_Stream"));
                for (int i = 0; i < stream_list.size(); ++i) {
                    writer.write("stream" + stream_list.get(i) + "\n");
                }
                writer.close();
                new LinuxCommandExecutor().copyActiveStream("/home/user/Active_Stream", "/usr/local/bin/Active_Stream");
                new LinuxCommandExecutor().givePermission("/usr/local/bin/Active_Stream");
            }
            catch (Exception e) {
                System.out.println("Exception at file write:" + e.getMessage());
            }
        }
    }

    static class restartStream
    implements HttpHandler {
        private int stream_id;
        private String remove_file;

        restartStream() {
        }

        public int getStream_id() {
            return this.stream_id;
        }

        public void setStream_id(int stream_id) {
            this.stream_id = stream_id;
        }

        public String getRemove_file() {
            return this.remove_file;
        }

        public void setRemove_file(String remove_file) {
            this.remove_file = remove_file;
        }

        @Override
        public void handle(HttpExchange he) throws IOException {
            String line;
            System.out.println("client connected..StreamRestart");
            System.out.println("get DVB info----------------------------------------------------------------");
            InputStream intp = he.getRequestBody();
            BufferedReader br = new BufferedReader(new InputStreamReader(intp));
            StringBuilder builder = new StringBuilder();
            String data = "";
            while ((line = br.readLine()) != null) {
                builder.append(line);
            }
            data = builder.toString();
            Object obj = null;
            JSONObject json_data = null;
            try {
                JSONParser parser = new JSONParser();
                obj = parser.parse(data);
                json_data = (JSONObject)obj;
            }
            catch (Exception parser) {
                // empty catch block
            }
            System.out.println("json" + json_data);
            this.setStream_id(Integer.parseInt(json_data.get((Object)"stream_id").toString()));
            this.setRemove_file(json_data.get((Object)"remove_file").toString());
            String response = this.restartStream(this.stream_id, this.remove_file);
            he.sendResponseHeaders(200, response.getBytes().length);
            OutputStream os = he.getResponseBody();
            os.write(response.getBytes());
            os.close();
        }

        public String restartStream(int stream_id, String remove_file) {
            try {
                System.out.println("Stream restart----------------------------------------------------------------");
                this.restart(stream_id);
                this.removeFile(remove_file);
            }
            catch (Exception e) {
                System.out.println("Exception at restart:" + e.getMessage());
            }
            return "Success";
        }

        public String restart(int stream_id) {
            String output = "";
            try {
                String[] commands;
                System.out.println("STREAM ID:" + stream_id);
                for (String c : commands = new String[]{"stream" + stream_id + " stop", "stream" + stream_id + " start"}) {
                    Process process = Runtime.getRuntime().exec(c, null, null);
                    BufferedReader in = new BufferedReader(new InputStreamReader(process.getInputStream()));
                    String line = null;
                    while ((line = in.readLine()) != null) {
                        output = output + "\n" + line;
                    }
                    Thread.sleep(2000L);
                }
            }
            catch (Exception e) {
                System.out.println("Exception at playout function:" + e.getMessage());
                output = output + e.getMessage();
                return output;
            }
            return output;
        }

        public String removeFile(String file) {
            String result = "";
            try {
                System.out.println("file:" + file);
                String[] commands = new String[]{"rm " + file};
                String output = "";
                for (String c : commands) {
                    Process process = Runtime.getRuntime().exec(c, null, null);
                    BufferedReader in = new BufferedReader(new InputStreamReader(process.getInputStream()));
                    String line = null;
                    while ((line = in.readLine()) != null) {
                        output = output + "\n" + line;
                    }
                }
                result = result + output;
                System.out.println("Success:" + result);
            }
            catch (Exception e) {
                System.out.println(e.getMessage());
            }
            return result;
        }
    }

    static class getDVBInfo
    implements HttpHandler {
        getDVBInfo() {
        }

        @Override
        public void handle(HttpExchange he) throws IOException {
            String line;
            InputStream intp = he.getRequestBody();
            BufferedReader br = new BufferedReader(new InputStreamReader(intp));
            StringBuilder builder = new StringBuilder();
            String data = "";
            while ((line = br.readLine()) != null) {
                builder.append(line);
            }
            data = builder.toString();
            Object obj = null;
            JSONObject json_data = null;
            try {
                JSONParser parser = new JSONParser();
                obj = parser.parse(data);
                json_data = (JSONObject)obj;
            }
            catch (Exception e) {
                System.out.println("Exception at Parsing:" + e.getMessage());
            }
            String responce = "Success";
            he.sendResponseHeaders(200, responce.getBytes().length);
            OutputStream os = he.getResponseBody();
            os.write(responce.getBytes());
            os.close();
            System.out.println("json" + json_data);
        }
    }
}

