/*
 * Decompiled with CFR 0.152.
 */
package inputstatus;

import LinuxCommandExecutor.LinuxCommandExecutor;
import entity.Channels;
import entity.Input;
import entityDB.InputDB;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.List;
import java.util.Scanner;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;

public class InputStatus {
    static BufferedWriter bw;
    static String filePath;

    public static void main(String[] args) {
        try {
            InputStatus.inputMethod("file");
        }
        catch (Exception e) {
            System.err.println("Exception in main: " + e.getMessage());
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void streamStatus() {
        try {
            List<Channels> channellist = new InputDB().getChannelsAll();
            for (Channels obj : channellist) {
                boolean result = false;
                try {
                    URL url = new URL("http://" + obj.getServerip() + "/pid/stream" + obj.getId() + "-pid");
                    URLConnection c = url.openConnection();
                    c.connect();
                    c.setReadTimeout(1000);
                    InputStream is = c.getInputStream();
                    DataInputStream dis = new DataInputStream(new BufferedInputStream(is));
                    String line = "";
                    String output = "";
                    while ((line = dis.readLine()) != null) {
                        output = output + line;
                    }
                    if (output != null) {
                        result = true;
                    }
                    System.out.println(obj.getChannelname());
                    System.out.println(result);
                }
                catch (Exception exception) {}
                continue;
                finally {
                    new InputDB().updateStreamStatus(result, obj.getId());
                }
            }
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    public static void inputMethod(String methodname) throws InterruptedException, ClassNotFoundException {
        List<Input> inputList = new InputDB().getActiveInputsIPTV(methodname);
        System.out.println(inputList.size());
        if (methodname.equalsIgnoreCase("ffprobe")) {
            for (Input i : inputList) {
                InputStatus.inputReadForffprobe(i.getUdp(), i.getId(), i.getServer_ip(), i.getStreamcount());
                Thread.sleep(2000L);
            }
        } else {
            String path = "/home/user/RIDSYSPACKAGE/riptv/live/INPUTSTATUS/RStream";
            for (Input i : inputList) {
                System.out.println("udp: " + i.getUdp());
                String protocol = "";
                boolean status = false;
                protocol = i.getUdp().startsWith("udp") ? "ip" : (i.getUdp().startsWith("http") ? "http" : "ip");
                System.out.println("protocol: " + protocol);
                boolean issec = false;
                if (i.getServer_ip() != null && !i.getServer_ip().equals("")) {
                    if (new InputDB().isSecondary(i.getServer_ip())) {
                        status = InputStatus.secondaryInputStatus(path, protocol, i.getUdp(), i.getServer_ip());
                        issec = true;
                    } else {
                        status = InputStatus.primaryInputStatus(path, protocol, i.getUdp());
                        issec = false;
                    }
                } else {
                    status = InputStatus.primaryInputStatus(path, protocol, i.getUdp());
                    issec = false;
                }
                new InputDB().updateStreamInputStatus(i.getId(), status);
                System.out.println("----------------------------------------finished------------------------------------" + status);
            }
        }
    }

    public static boolean primaryInputStatus(String path, String protocol, String udp) {
        System.out.println("reading primary input status");
        boolean status = false;
        String oldprotocol = "";
        String oldurl = "";
        String newurl = "";
        newurl = udp.substring(6, udp.length());
        String cmd = "PROTOCOL=\"ip\" INPUT_URL=\"" + newurl + "\" $source /home/user/RIDSYSPACKAGE/riptv/live/INPUTSTATUS/analyse_input";
        try {
            File file = new File(path);
            Scanner scanner = new Scanner(file);
            String fileContents = "";
            while (scanner.hasNextLine()) {
                fileContents = fileContents + scanner.nextLine() + "\n";
            }
            String[] s = fileContents.split("\n");
            int a = 0;
            for (String ss : s) {
                if (ss.contains("PROTOCOL")) {
                    System.out.println(ss);
                    oldprotocol = ss;
                    oldprotocol = oldprotocol.substring(oldprotocol.lastIndexOf("=") + 1, oldprotocol.length());
                    System.out.println("oldpro: " + oldprotocol);
                }
                if (ss.contains("INPUT_URL")) {
                    System.out.println(ss);
                    oldurl = ss;
                    oldurl = oldurl.substring(oldurl.lastIndexOf("=") + 1, oldurl.length());
                    newurl = protocol.equals("ip") ? udp.substring(6, udp.length()) : (protocol.equals("http") ? udp : udp.substring(6, udp.length()));
                    System.out.println("oldurl: " + oldurl);
                }
                ++a;
            }
            scanner.close();
            fileContents = fileContents.replace(oldurl, "\"" + newurl + "\"");
            fileContents = fileContents.replace(oldprotocol, "\"" + protocol + "\"");
            System.out.println(fileContents);
            FileWriter writer = new FileWriter(file);
            writer.write(fileContents);
            writer.close();
            status = new LinuxCommandExecutor().scriptExe(path);
        }
        catch (Exception e) {
            System.out.println("Exception at primary: " + e);
        }
        return status;
    }

    public static boolean secondaryInputStatus(String path, String protocol, String udp, String server_ip) {
        boolean status;
        block15: {
            status = false;
            try {
                URL urL = new URL("http://" + server_ip + ":8000/getInputStatus");
                System.out.println("url--" + urL);
                HttpURLConnection httpURLConnection = (HttpURLConnection)urL.openConnection();
                httpURLConnection.setDoOutput(true);
                OutputStream os = httpURLConnection.getOutputStream();
                OutputStreamWriter osw = new OutputStreamWriter(os, "UTF-8");
                JSONObject obj = new JSONObject();
                obj.put((Object)"path", (Object)path);
                obj.put((Object)"protocol", (Object)protocol);
                obj.put((Object)"udp", (Object)udp);
                osw.write(obj.toJSONString());
                osw.flush();
                osw.close();
                String line = "false";
                if (httpURLConnection.getResponseCode() != 200) break block15;
                try (BufferedReader br = new BufferedReader(new InputStreamReader(httpURLConnection.getInputStream()));){
                    line = br.readLine();
                    System.out.println("line from server=" + line);
                }
                if (line.equalsIgnoreCase("true")) {
                    status = true;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return status;
    }

    public static boolean inputReadForffprobe(String udp, int id, String server_ip, int streamcount) throws ClassNotFoundException {
        boolean status;
        block28: {
            new InputDB().deleteTrackbyInputID(id);
            status = false;
            JSONArray Programs = new JSONArray();
            try {
                String json_string = "";
                if (!new InputDB().isSecondary(server_ip)) {
                    ProcessBuilder processBuilder = new ProcessBuilder(new String[0]);
                    processBuilder.command("bash", "-c", "timeout 30s ffprobe -v quiet -print_format json -show_programs " + udp);
                    Process process = processBuilder.start();
                    BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
                    String line = "";
                    while ((line = reader.readLine()) != null) {
                        json_string = json_string + line;
                        status = true;
                    }
                } else {
                    URL urL = new URL("http://" + server_ip + ":8000/StreamExtracter");
                    HttpURLConnection httpURLConnection = (HttpURLConnection)urL.openConnection();
                    httpURLConnection.setDoOutput(true);
                    OutputStream os = httpURLConnection.getOutputStream();
                    OutputStreamWriter osw = new OutputStreamWriter(os, "UTF-8");
                    JSONObject obj = new JSONObject();
                    obj.put((Object)"udp", (Object)udp);
                    osw.write(udp);
                    osw.flush();
                    osw.close();
                    BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(httpURLConnection.getInputStream()));
                    String line = "";
                    json_string = line = bufferedReader.readLine();
                    System.out.println("line from server" + line);
                    if (line != null) {
                        status = true;
                    }
                }
                System.out.println(json_string);
                if (json_string != null && !json_string.equals("")) {
                    new InputDB().updateStreamInputStatus(id, true);
                } else {
                    new InputDB().updateStreamInputStatus(id, false);
                }
                System.out.println(streamcount);
                if (streamcount != 0 || json_string == null || json_string.equals("")) break block28;
                JSONParser parser = new JSONParser();
                Object obj1 = parser.parse(json_string);
                JSONObject json_data = (JSONObject)obj1;
                try {
                    Programs = (JSONArray)json_data.get((Object)"programs");
                }
                catch (Exception e) {
                    System.out.println("No Programs");
                }
                for (int j = 0; j < Programs.size(); ++j) {
                    String service_name;
                    String provider = "";
                    JSONObject program = (JSONObject)Programs.get(j);
                    int program_num = Integer.parseInt(program.get((Object)"program_num").toString());
                    JSONObject service_obj = (JSONObject)program.get((Object)"tags");
                    try {
                        service_name = service_obj.get((Object)"service_name").toString();
                    }
                    catch (Exception e) {
                        service_name = "Unknown";
                    }
                    JSONArray Streams = (JSONArray)program.get((Object)"streams");
                    JSONObject tags = new JSONObject();
                    try {
                        tags = (JSONObject)program.get((Object)"tags");
                        provider = tags.get((Object)"service_provider").toString();
                    }
                    catch (Exception e) {
                        System.out.println(e);
                        provider = "No provider";
                    }
                    try {
                        for (int k = 0; k < Streams.size(); ++k) {
                            String language;
                            JSONObject stream = (JSONObject)Streams.get(k);
                            String codec_type = "";
                            try {
                                codec_type = stream.get((Object)"codec_type").toString();
                            }
                            catch (Exception e) {
                                codec_type = "No codec";
                            }
                            if (codec_type.contains("video") || codec_type.contains("no codec")) {
                                String v_codec = codec_type.contains("video") ? stream.get((Object)"codec_name").toString() : "no codec";
                                if (!new InputDB().getCountByStreamNameProgramNoForUDP(service_name, id, program_num)) {
                                    new InputDB().insertInputChannels(service_name, v_codec, program_num, id, provider);
                                } else {
                                    new InputDB().updateInputStreamDetails(id, service_name, v_codec, program_num, provider);
                                }
                            }
                            if (!codec_type.contains("audio") && !codec_type.contains("no codec")) continue;
                            String a_codec = null;
                            String bitrate = null;
                            try {
                                if (codec_type.contains("audio")) {
                                    a_codec = stream.get((Object)"codec_name").toString();
                                    bitrate = stream.get((Object)"bit_rate").toString();
                                } else {
                                    a_codec = "no codec";
                                }
                                JSONObject stream_obj = (JSONObject)stream.get((Object)"tags");
                                language = stream_obj.get((Object)"language").toString();
                            }
                            catch (Exception e) {
                                language = "Default";
                                System.out.println("Exception at streams tag:" + e.getMessage());
                            }
                            if (bitrate == null || bitrate.equals("")) {
                                bitrate = "0";
                            }
                            new InputDB().insertAudioTrack(language, a_codec, id, program_num, bitrate);
                        }
                    }
                    catch (Exception e) {
                        System.out.println("Exception at streams:" + e.getMessage());
                    }
                    new InputDB().updateStreamInputStatuswithStreamCount(id, status, Programs.size());
                }
            }
            catch (Exception e) {
                status = false;
                System.out.println("Exception at trackextractor :" + e.getMessage());
            }
        }
        return status;
    }

    public static boolean isSPTS(String udp) {
        boolean status = true;
        JSONArray Programs = new JSONArray();
        try {
            ProcessBuilder processBuilder = new ProcessBuilder(new String[0]);
            processBuilder.command("bash", "-c", "timeout 30s ffprobe -v quiet -print_format json -show_programs -analyzeduration 100M -probesize 100M " + udp);
            Process process = processBuilder.start();
            BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            String json_string = "";
            String line = null;
            while ((line = reader.readLine()) != null) {
                json_string = json_string + line;
                status = true;
            }
            JSONParser parser = new JSONParser();
            Object obj = parser.parse(json_string);
            JSONObject json_data = (JSONObject)obj;
            try {
                Programs = (JSONArray)json_data.get((Object)"programs");
            }
            catch (Exception e) {
                System.out.println("No Programs");
            }
            status = Programs.size() <= 1;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return status;
    }

    static {
        filePath = "/home/user/RIDSYSPACKAGE/riptv/live/INPUTSTATUS/dist/udpstatus.txt";
    }
}

